/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.openoa.base.entity.BpmProcessName;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmProcessVo;
import org.openoa.engine.bpmnconf.mapper.BpmProcessNameMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNameService;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmProcessNameServiceImpl
extends ServiceImpl<BpmProcessNameMapper, BpmProcessName>
implements BpmProcessNameService {
    private static Map<String, BpmProcessVo> processVoMap = new ConcurrentHashMap<String, BpmProcessVo>();

    @Override
    public List<BaseIdTranStruVo> listResult() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        List bpmProcessNames = Optional.ofNullable(((BpmProcessNameMapper)this.getBaseMapper()).selectList((Wrapper)wrapper)).orElse(Collections.emptyList());
        List<BaseIdTranStruVo> list = bpmProcessNames.stream().map(o -> BaseIdTranStruVo.builder().id(o.getId().toString()).name(o.getProcessName()).build()).collect(Collectors.toList());
        return list;
    }

    @Override
    public BpmProcessName findProcessName(String processName) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.eq((Object)"process_name", (Object)processName);
        List bpmProcessNames = Optional.ofNullable(((BpmProcessNameMapper)this.getBaseMapper()).selectList((Wrapper)wrapper)).orElse(Collections.emptyList());
        if (!ObjectUtils.isEmpty(bpmProcessNames)) {
            return (BpmProcessName)bpmProcessNames.get(0);
        }
        return new BpmProcessName();
    }

    @Override
    public Map<String, BpmProcessVo> loadProcessName() {
        HashMap<String, BpmProcessVo> map = new HashMap<String, BpmProcessVo>();
        List<BpmProcessVo> list = ((BpmProcessNameMapper)this.getBaseMapper()).allProcess();
        if (list == null) {
            return Collections.emptyMap();
        }
        for (BpmProcessVo next : list) {
            map.put(next.getProcessKey(), next);
        }
        processVoMap.putAll(map);
        return map;
    }

    @Override
    public BpmProcessVo get(String processKey) {
        BpmProcessVo bpmProcessVo = processVoMap.get(processKey);
        if (!ObjectUtils.isEmpty((Object)bpmProcessVo)) {
            return bpmProcessVo;
        }
        this.loadProcessName();
        return Optional.ofNullable(processVoMap.get(processKey)).orElse(new BpmProcessVo());
    }
}

