/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.entity.BpmProcessNotice;
import org.openoa.base.entity.BpmnTemplate;
import org.openoa.base.vo.BpmProcessDeptVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.engine.bpmnconf.mapper.BpmProcessNoticeMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmnTemplateServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class BpmProcessNoticeServiceImpl
extends ServiceImpl<BpmProcessNoticeMapper, BpmProcessNotice>
implements BpmProcessNoticeService {
    @Autowired
    private BpmnTemplateServiceImpl bpmnTemplateService;

    @Override
    public void saveProcessNotice(BpmProcessDeptVo vo) {
        String processKey = vo.getProcessKey();
        ArrayList<Integer> notifyTypeIds = vo.getNotifyTypeIds();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"process_key", (Object)processKey);
        List templateVos = vo.getTemplateVos();
        if (!CollectionUtils.isEmpty((Collection)templateVos)) {
            List bpmProcessNotices = ((BpmProcessNoticeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)bpmProcessNotices)) {
                List advancedNotifyIds = templateVos.stream().flatMap(x -> x.getMessageSendTypeList().stream()).map(a -> a.getId().intValue()).distinct().collect(Collectors.toList());
                notifyTypeIds = new ArrayList<Integer>(advancedNotifyIds);
            }
            BpmnConfVo confVo = new BpmnConfVo();
            confVo.setFormCode(processKey);
            confVo.setTemplateVos(templateVos);
            LambdaQueryWrapper delWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmnTemplate::getFormCode, (Object)processKey)).isNull(BpmnTemplate::getNodeId);
            this.bpmnTemplateService.remove((Wrapper)delWrapper);
            this.bpmnTemplateService.editBpmnTemplate(confVo, null);
        }
        if (!ObjectUtils.isEmpty((Object)notifyTypeIds)) {
            ((BpmProcessNoticeMapper)this.getBaseMapper()).delete((Wrapper)wrapper);
            notifyTypeIds.forEach(o -> ((BpmProcessNoticeMapper)this.getBaseMapper()).insert(BpmProcessNotice.builder().processKey(processKey).type(o).build()));
        }
    }

    @Override
    public List<BpmProcessNotice> processNoticeList(String processKey) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"process_key", (Object)processKey);
        return ((BpmProcessNoticeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }

    @Override
    public Map<String, List<BpmProcessNotice>> processNoticeMap(List<String> processKeys) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BpmProcessNotice::getProcessKey, processKeys);
        List bpmProcessNotices = ((BpmProcessNoticeMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return bpmProcessNotices.stream().collect(Collectors.groupingBy(BpmProcessNotice::getProcessKey));
    }
}

