/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openoa.base.constant.enums.ProcessJurisdictionEnum;
import org.openoa.base.entity.BpmProcessPermissions;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmProcessDeptVo;
import org.openoa.engine.bpmnconf.mapper.BpmProcessPermissionsMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmProcessPermissionsService;
import org.openoa.engine.vo.GenericEmployee;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BpmProcessPermissionsServiceImpl
extends ServiceImpl<BpmProcessPermissionsMapper, BpmProcessPermissions>
implements BpmProcessPermissionsService {
    public void saveProcessPermissions(BpmProcessDeptVo vo) {
        GenericEmployee genericEmployee = new GenericEmployee();
        genericEmployee.setUserId(SecurityUtils.getLogInEmpIdSafe());
        genericEmployee.setUsername(SecurityUtils.getLogInEmpNameSafe());
        QueryWrapper permissionsWrapper = new QueryWrapper();
        permissionsWrapper.eq((Object)"process_key", (Object)vo.getProcessKey());
        ((BpmProcessPermissionsMapper)this.getBaseMapper()).delete((Wrapper)permissionsWrapper);
        if (!CollectionUtils.isEmpty((Collection)vo.getCreateUserIds())) {
            vo.getCreateUserIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.CREATE_TYPE.getCode())).userId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getCreateDeptIds())) {
            vo.getCreateDeptIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.CREATE_TYPE.getCode())).depId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getViewdeptIds())) {
            vo.getViewdeptIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.VIEW_TYPE.getCode())).depId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getViewUserIds())) {
            vo.getViewUserIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.VIEW_TYPE.getCode())).userId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getControlUserIds())) {
            vo.getControlUserIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.CONTROL_TYPE.getCode())).userId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getControlDeptIds())) {
            vo.getControlDeptIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.CONTROL_TYPE.getCode())).depId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getCreateOfficeIds())) {
            vo.getCreateOfficeIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.CREATE_TYPE.getCode())).officeId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
        if (!CollectionUtils.isEmpty((Collection)vo.getViewOfficeIds())) {
            vo.getViewOfficeIds().forEach(o -> ((BpmProcessPermissionsMapper)this.getBaseMapper()).insert(BpmProcessPermissions.builder().permissionsType(Integer.valueOf(ProcessJurisdictionEnum.VIEW_TYPE.getCode())).officeId(o).processKey(vo.getProcessKey()).createUser(genericEmployee.getUserId()).createTime(new Date()).build()));
        }
    }

    @Override
    public List<BpmProcessPermissions> permissionsList(String processKey, Integer permissionsType, boolean isUser) {
        QueryWrapper permissionsWrapper = new QueryWrapper();
        permissionsWrapper.eq((Object)"process_key", (Object)processKey);
        permissionsWrapper.eq((Object)"permissions_type", (Object)permissionsType);
        if (isUser) {
            permissionsWrapper.ne((Object)"user_id", (Object)Character.valueOf(' '));
        } else {
            permissionsWrapper.ne((Object)"dep_id", (Object)Character.valueOf(' '));
        }
        return ((BpmProcessPermissionsMapper)this.getBaseMapper()).selectList((Wrapper)permissionsWrapper);
    }

    @Override
    public List<BpmProcessPermissions> permissionsList(String processKey, Integer permissionsType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"process_key", (Object)processKey);
        wrapper.eq((Object)"permissions_type", (Object)permissionsType);
        wrapper.ne((Object)"office_id", (Object)Character.valueOf(' '));
        return ((BpmProcessPermissionsMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }
}

