/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmVerifyInfo;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.engine.bpmnconf.mapper.BpmVerifyInfoMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmVerifyInfoService;
import org.openoa.engine.utils.AFWrappers;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BpmVerifyInfoServiceImpl
extends ServiceImpl<BpmVerifyInfoMapper, BpmVerifyInfo>
implements BpmVerifyInfoService {
    @Override
    public void addVerifyInfo(String businessId, String remark, Integer businessType, String taskName, Integer verifyStatuss) {
        BpmVerifyInfo verifyInfo = new BpmVerifyInfo();
        verifyInfo.setBusinessId(businessId);
        verifyInfo.setId(null);
        verifyInfo.setBusinessType(businessType);
        verifyInfo.setVerifyDate(new Date());
        verifyInfo.setVerifyUserName(SecurityUtils.getLogInEmpName());
        verifyInfo.setTaskName(taskName);
        verifyInfo.setVerifyUserId(SecurityUtils.getLogInEmpIdStr());
        verifyInfo.setVerifyDesc(Strings.isNullOrEmpty((String)remark) ? "\u540c\u610f" : remark);
        verifyInfo.setVerifyStatus(verifyStatuss);
        verifyInfo.setTenantId(MultiTenantUtil.getCurrentTenantId());
        ((BpmVerifyInfoMapper)this.getBaseMapper()).insert(verifyInfo);
    }

    @Override
    public Map<String, BpmVerifyInfo> getByProcInstIdAndTaskDefKey(String processNumber, String taskDefKey) {
        if (StringUtils.isBlank((CharSequence)processNumber)) {
            throw new AFBizException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isEmpty((CharSequence)taskDefKey)) {
            return null;
        }
        List verifyInfos = this.list((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(BpmVerifyInfo::getProcessCode, (Object)processNumber)).eq(BpmVerifyInfo::getTaskDefKey, (Object)taskDefKey));
        Map<String, BpmVerifyInfo> verifyInfoMap = verifyInfos.stream().collect(Collectors.toMap(a -> a.getTaskDefKey() + a.getVerifyUserId(), b -> b, (v1, v2) -> v1));
        return verifyInfoMap;
    }

    @Override
    public Map<String, List<BpmVerifyInfoVo>> getBpmVerifyInfoBatch(List<String> processCodes) {
        List<BpmVerifyInfoVo> vos = ((BpmVerifyInfoMapper)this.getBaseMapper()).verifyInfoList(BpmVerifyInfoVo.builder().processCodeList(processCodes).build());
        if (!ObjectUtils.isEmpty(vos)) {
            return vos.stream().collect(Collectors.groupingBy(BpmVerifyInfoVo::getProcessCode));
        }
        return new HashMap<String, List<BpmVerifyInfoVo>>();
    }

    @Override
    public Map<String, String> listBpmVerifyInfoVo(List<String> processCodes) {
        HashMap map = Maps.newHashMap();
        Map<String, List<BpmVerifyInfoVo>> listMap = this.getBpmVerifyInfoBatch(processCodes);
        if (!ObjectUtils.isEmpty(listMap)) {
            listMap.forEach((key, value) -> {
                List list = (List)listMap.get(key);
                StringBuffer buf = new StringBuffer();
                for (BpmVerifyInfoVo vo : list) {
                    String join = StringUtils.join((Object[])new String[]{vo.getTaskName(), ":", vo.getVerifyUserName(), "--"});
                    buf.append(join);
                }
                String verify = buf.toString().substring(0, buf.toString().length() - 2);
                map.put(key, verify);
            });
        }
        return map;
    }
}

