/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.ButtonPageTypeEnum;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.entity.BpmnNodeButtonConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.vo.BpmnNodeButtonConfBaseVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeButtonConfMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnNodeButtonConfService;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class BpmnNodeButtonConfServiceImpl
extends ServiceImpl<BpmnNodeButtonConfMapper, BpmnNodeButtonConf>
implements BpmnNodeButtonConfService {
    @Override
    public void editButtons(BpmnNodeVo bpmnNodeVo, Long bpmnNodeId) {
        List approvalPageButtons;
        List startPageButtons;
        ((BpmnNodeButtonConfMapper)this.getBaseMapper()).delete((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeId));
        boolean isHaveCxtjButton = false;
        BpmnNodeButtonConfBaseVo buttons = bpmnNodeVo.getButtons();
        if (ObjectUtils.isEmpty((Object)buttons)) {
            BpmnNodeButtonConfBaseVo buttonConfBaseVo = new BpmnNodeButtonConfBaseVo();
            buttonConfBaseVo.setStartPage((List)Lists.newArrayList());
            buttonConfBaseVo.setApprovalPage((List)Lists.newArrayList((Object[])new Integer[]{2}));
            buttons = buttonConfBaseVo;
        }
        if (!ObjectUtils.isEmpty((Object)(startPageButtons = buttons.getStartPage()))) {
            this.saveBatch(this.getBpmnNodeButtonConfs(bpmnNodeId, buttons.getStartPage(), ButtonPageTypeEnum.INITIATE));
        }
        if (!ObjectUtils.isEmpty((Object)(approvalPageButtons = buttons.getApprovalPage()))) {
            this.saveBatch(this.getBpmnNodeButtonConfs(bpmnNodeId, buttons.getApprovalPage(), ButtonPageTypeEnum.AUDIT));
            if (buttons.getApprovalPage().contains(ButtonTypeEnum.BUTTON_TYPE_RESUBMIT.getCode())) {
                isHaveCxtjButton = true;
            }
        }
        if (bpmnNodeVo.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode()) && !isHaveCxtjButton) {
            ((BpmnNodeButtonConfMapper)this.getBaseMapper()).insert(BpmnNodeButtonConf.builder().bpmnNodeId(bpmnNodeId).buttonPageType(Integer.valueOf(ButtonPageTypeEnum.AUDIT.getCode())).buttonType(ButtonTypeEnum.BUTTON_TYPE_RESUBMIT.getCode()).buttonName(ButtonTypeEnum.getDescByCode((Integer)ButtonTypeEnum.BUTTON_TYPE_RESUBMIT.getCode())).tenantId(MultiTenantUtil.getCurrentTenantId()).build());
        }
    }

    private List<BpmnNodeButtonConf> getBpmnNodeButtonConfs(Long bpmnNodeId, List<Integer> buttons, ButtonPageTypeEnum buttonPageTypeEnum) {
        return buttons.stream().distinct().map(o -> BpmnNodeButtonConf.builder().bpmnNodeId(bpmnNodeId).buttonPageType(Integer.valueOf(buttonPageTypeEnum.getCode())).buttonType(o).buttonName(ButtonTypeEnum.getDescByCode((Integer)o)).tenantId(MultiTenantUtil.getCurrentTenantId()).build()).collect(Collectors.toList());
    }
}

