/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.BpmnTemplate;
import org.openoa.base.util.AntCollectionUtil;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.engine.bpmnconf.mapper.BpmnTemplateMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnTemplateService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class BpmnTemplateServiceImpl
extends ServiceImpl<BpmnTemplateMapper, BpmnTemplate>
implements BpmnTemplateService {
    @Override
    public void editBpmnTemplate(BpmnConfVo bpmnConfVo, Long confId) {
        List templateVos = bpmnConfVo.getTemplateVos();
        if (ObjectUtils.isEmpty((Object)templateVos)) {
            return;
        }
        List bpmnTemplateList = bpmnConfVo.getTemplateVos().stream().map(o -> {
            BpmnTemplate bpmnTemplate = new BpmnTemplate();
            BeanUtils.copyProperties((Object)o, (Object)bpmnTemplate);
            bpmnTemplate.setConfId(confId);
            bpmnTemplate.setInforms(StringUtils.join((Iterable)o.getInformIdList(), (String)","));
            bpmnTemplate.setEmps(StringUtils.join((Iterable)o.getEmpIdList(), (String)","));
            bpmnTemplate.setRoles(StringUtils.join((Iterable)o.getRoleIdList(), (String)","));
            bpmnTemplate.setFuncs(StringUtils.join((Iterable)o.getFuncIdList(), (String)","));
            bpmnTemplate.setMessageSendType(AntCollectionUtil.joinBaseNumIdTransVoToString((Collection)o.getMessageSendTypeList()));
            bpmnTemplate.setFormCode(bpmnConfVo.getFormCode());
            bpmnTemplate.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
            bpmnTemplate.setTenantId(MultiTenantUtil.getCurrentTenantId());
            return bpmnTemplate;
        }).collect(Collectors.toList());
        this.saveBatch(bpmnTemplateList);
    }

    @Override
    public void editBpmnTemplate(BpmnNodeVo bpmnNodeVo) {
        List templateVos = bpmnNodeVo.getTemplateVos();
        if (ObjectUtils.isEmpty((Object)templateVos)) {
            return;
        }
        this.saveBatch(templateVos.stream().map(o -> {
            BpmnTemplate bpmnTemplate = new BpmnTemplate();
            BeanUtils.copyProperties((Object)o, (Object)bpmnTemplate);
            bpmnTemplate.setId(null);
            bpmnTemplate.setConfId(bpmnNodeVo.getConfId());
            bpmnTemplate.setNodeId(bpmnNodeVo.getId());
            bpmnTemplate.setInforms(StringUtils.join((Iterable)o.getInformIdList(), (String)","));
            bpmnTemplate.setEmps(StringUtils.join((Iterable)o.getEmpIdList(), (String)","));
            bpmnTemplate.setRoles(StringUtils.join((Iterable)o.getRoleIdList(), (String)","));
            bpmnTemplate.setFuncs(StringUtils.join((Iterable)o.getFuncIdList(), (String)","));
            bpmnTemplate.setMessageSendType(AntCollectionUtil.joinBaseNumIdTransVoToString((Collection)o.getMessageSendTypeList()));
            bpmnTemplate.setFormCode(bpmnNodeVo.getFormCode());
            bpmnTemplate.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
            bpmnTemplate.setTenantId(MultiTenantUtil.getCurrentTenantId());
            return bpmnTemplate;
        }).collect(Collectors.toList()));
    }
}

