/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.openoa.base.constant.enums.SortTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.QuickEntry;
import org.openoa.base.util.PageUtils;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.mapper.QuickEntryMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryService;
import org.openoa.engine.vo.QuickEntryVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class QuickEntryServiceImpl
extends ServiceImpl<QuickEntryMapper, QuickEntry>
implements QuickEntryService {
    private static final Logger log = LoggerFactory.getLogger(QuickEntryServiceImpl.class);

    @Override
    public boolean deleteQuickEntry(Long id) {
        QuickEntry quickEntry = (QuickEntry)this.getById(id);
        quickEntry.setIsDel(Integer.valueOf(1));
        this.updateById(quickEntry);
        return true;
    }

    @Override
    public ResultAndPage<QuickEntryVo> findProcessList(PageDto pageDto, QuickEntryVo vo) {
        LinkedHashMap<String, SortTypeEnum> orderFieldMap = new LinkedHashMap<String, SortTypeEnum>();
        orderFieldMap.put("sort", SortTypeEnum.ASC);
        orderFieldMap.put("create_time", SortTypeEnum.DESC);
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto, orderFieldMap);
        page.setRecords(((QuickEntryMapper)this.getBaseMapper()).listQuickEntry(page, vo));
        this.getPcProcessData((Page<QuickEntryVo>)page);
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    public Page<QuickEntryVo> getPcProcessData(Page<QuickEntryVo> page) {
        return page.setRecords(page.getRecords().stream().map(o -> {
            if (!StringUtil.isEmpty((CharSequence)o.getTypeIds())) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                String[] split = o.getTypeIds().split("\\,");
                if (split.length > 0) {
                    for (String typeId : split) {
                        list.add(Integer.parseInt(typeId));
                    }
                }
                o.setTypes(list);
            }
            if (o.getIsDel().equals(0)) {
                o.setStateName("\u542f\u7528");
            } else {
                o.setStateName("\u7981\u7528");
            }
            return o;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<QuickEntryVo> searchQuickEntry(String search, Integer limitSize) {
        if (limitSize == null) {
            limitSize = 10;
        }
        if (!StringUtil.isEmpty((CharSequence)search)) {
            return ((QuickEntryMapper)this.getBaseMapper()).searchQuickEntry(search, limitSize);
        }
        return Collections.EMPTY_LIST;
    }

    public Object getQuickVarUrl(Long id, String requestIp) {
        QuickEntry quickEntry = (QuickEntry)((QuickEntryMapper)this.getBaseMapper()).selectById(id);
        if (QuickEntry.VARIABLE_URL_FLAG_FALSE.equals(quickEntry.getVariableUrlFlag())) {
            return quickEntry.getRoute();
        }
        return quickEntry.getRoute();
    }
}

