/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.openoa.base.entity.QuickEntryType;
import org.openoa.engine.bpmnconf.mapper.QuickEntryTypeMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.QuickEntryTypeService;
import org.openoa.engine.vo.QuickEntryVo;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class QuickEntryTypeServiceImpl
extends ServiceImpl<QuickEntryTypeMapper, QuickEntryType>
implements QuickEntryTypeService {
    @Override
    public boolean addQuickEntryType(QuickEntryVo vo) {
        if (!CollectionUtils.isEmpty(vo.getTypes())) {
            List<QuickEntryType> quickEntryTypes = this.entryTypeList(vo.getId());
            for (QuickEntryType quickEntryType : quickEntryTypes) {
                ((QuickEntryTypeMapper)this.getBaseMapper()).deleteById(quickEntryType);
            }
            for (Integer type : vo.getTypes()) {
                ((QuickEntryTypeMapper)this.getBaseMapper()).insert(QuickEntryType.builder().createTime(new Date()).quickEntryId(Long.valueOf(vo.getId().longValue())).type(type).typeName(type == 1 ? "PC" : "APP").build());
            }
        }
        return true;
    }

    @Override
    public List<QuickEntryType> quickEntryTypeList(Boolean isApp) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        if (isApp.booleanValue()) {
            wrapper.eq((Object)"type", (Object)2);
        } else {
            wrapper.eq((Object)"type", (Object)1);
        }
        return ((QuickEntryTypeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }

    private List<QuickEntryType> entryTypeList(Integer quickEntryId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"is_del", (Object)0);
        wrapper.eq((Object)"quick_entry_id", (Object)quickEntryId);
        return ((QuickEntryTypeMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }
}

