/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collections;
import java.util.List;
import jodd.util.StringUtil;
import org.openoa.base.constant.enums.VersionIsForceEnums;
import org.openoa.base.entity.SysVersion;
import org.openoa.base.exception.AFBizException;
import org.openoa.engine.bpmnconf.mapper.SysVersionMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.SysVersionService;
import org.openoa.engine.vo.AppVersionVo;
import org.openoa.engine.vo.SysVersionVo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SysVersionServiceImpl
extends ServiceImpl<SysVersionMapper, SysVersion>
implements SysVersionService {
    public static final String APP_TYPE_ANDROID = "android";
    public static final String APP_TYPE_IOS = "ios";
    @Value(value="${app.ios.skip_force_version:}")
    private String iosSkipForceVersion;
    @Value(value="${app.android.skip_force_version:}")
    private String androidSkipForceVersion;

    @Override
    public AppVersionVo getAppVersion(String application, String appVersion) {
        boolean iosSkipFlag;
        if (StringUtil.isEmpty((CharSequence)application) || StringUtil.isEmpty((CharSequence)appVersion)) {
            return null;
        }
        AppVersionVo appVersionVo = new AppVersionVo();
        List<SysVersion> list = this.listVersion(null, appVersion, null, true);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        SysVersion cur = list.get(0);
        if (SysVersion.HIDE_STATUS_1.equals(cur.getIsHide())) {
            appVersionVo.setIsLatest(1);
            return appVersionVo;
        }
        Integer curIndex = cur.getIndex();
        Integer maxIndex = ((SysVersionMapper)this.getBaseMapper()).maxIndex();
        if (maxIndex == null) {
            return null;
        }
        if (curIndex == null) {
            return null;
        }
        if (curIndex.intValue() == maxIndex.intValue()) {
            appVersionVo.setIsLatest(1);
            return appVersionVo;
        }
        SysVersion sysVersion = this.listVersion(null, null, maxIndex, true).stream().findFirst().orElseGet(SysVersion::new);
        boolean androidSkipFlag = application.equalsIgnoreCase(APP_TYPE_ANDROID) && this.androidSkipForceVersion.equals(sysVersion.getVersion());
        boolean bl = iosSkipFlag = application.equalsIgnoreCase(APP_TYPE_IOS) && this.iosSkipForceVersion.equals(sysVersion.getVersion());
        if (androidSkipFlag || iosSkipFlag) {
            appVersionVo.setIsLatest(1);
            return appVersionVo;
        }
        List<SysVersion> maxList = this.listVersion(null, null, maxIndex, true);
        if (CollectionUtils.isEmpty(maxList)) {
            return null;
        }
        SysVersion maxVersion = maxList.get(0);
        list = this.listVersionByIndex(curIndex, maxIndex);
        boolean force = false;
        if (!CollectionUtils.isEmpty(list)) {
            for (SysVersion s : list) {
                if (VersionIsForceEnums.RECRUIT_TYPE_SYYG.getCode() != s.getIsForce().intValue()) continue;
                force = true;
            }
        } else {
            return null;
        }
        if (maxVersion != null) {
            if (application.equalsIgnoreCase(APP_TYPE_ANDROID)) {
                appVersionVo.setDownloadUrl(maxVersion.getAndroidUrl());
            } else if (application.equalsIgnoreCase(APP_TYPE_IOS)) {
                appVersionVo.setDownloadUrl(maxVersion.getIosUrl());
            }
        } else {
            return null;
        }
        appVersionVo.setDescription(maxVersion.getDescription());
        appVersionVo.setId(maxVersion.getId());
        appVersionVo.setVersion(maxVersion.getVersion());
        appVersionVo.setCurVersion(appVersion);
        if (!force) {
            appVersionVo.setIsLatest(0);
            appVersionVo.setIsForce(0);
            return appVersionVo;
        }
        appVersionVo.setIsLatest(0);
        appVersionVo.setIsForce(1);
        return appVersionVo;
    }

    @Override
    public List<SysVersion> listVersion(Long id, String version, Integer index, Boolean isDel) {
        if (id == null && StringUtil.isEmpty((CharSequence)version) && index == null && !isDel.booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (id != null) {
            wrapper.eq((Object)"id", (Object)id);
        }
        if (!StringUtil.isEmpty((CharSequence)version)) {
            wrapper.eq((Object)"version", (Object)version);
        }
        if (index != null) {
            wrapper.eq((Object)"`index`", (Object)index);
        }
        if (!isDel.booleanValue() && isDel.booleanValue()) {
            wrapper.eq((Object)"is_del", (Object)0);
        }
        return ((SysVersionMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }

    @Override
    public List<SysVersion> listVersionByIndex(Integer minIndex, Integer maxIndex) {
        if (minIndex == null || maxIndex == null) {
            return Collections.EMPTY_LIST;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.gt((Object)"`index`", (Object)minIndex);
        wrapper.le((Object)"`index`", (Object)maxIndex);
        return ((SysVersionMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
    }

    @Override
    public SysVersion getInfoByVersion(String version) {
        if (StringUtil.isEmpty((CharSequence)version)) {
            throw new AFBizException("\u7248\u672c\u53f7\u9519\u8bef!");
        }
        return (SysVersion)this.getOne((Wrapper)new QueryWrapper().eq((Object)"version", (Object)version));
    }

    @Override
    public SysVersionVo getDownloadQRcode() {
        SysVersionVo vo = new SysVersionVo();
        Integer index = ((SysVersionMapper)this.getBaseMapper()).maxIndex();
        SysVersion sysVersion = (SysVersion)this.getOne((Wrapper)new QueryWrapper().eq((Object)"`index`", (Object)index));
        vo.setDownloadCode(sysVersion.getDownloadCode());
        return vo;
    }

    private List<Integer> getIgnoreIndexs() {
        return Collections.EMPTY_LIST;
    }
}

