/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.UserEntrust;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.DataVo;
import org.openoa.base.vo.Entrust;
import org.openoa.base.vo.IdsVo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.mapper.UserEntrustMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.UserEntrustService;
import org.openoa.engine.utils.AFWrappers;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class UserEntrustServiceImpl
extends ServiceImpl<UserEntrustMapper, UserEntrust>
implements UserEntrustService {
    @Override
    public List<Entrust> getEntrustList() {
        return ((UserEntrustMapper)this.getBaseMapper()).getEntrustListNew(SecurityUtils.getLogInEmpIdSafe());
    }

    public UserEntrust getEntrustDetail(Integer id) {
        return (UserEntrust)((UserEntrustMapper)this.getBaseMapper()).selectById(id);
    }

    public ResultAndPage<Entrust> getEntrustPageList(PageDto pageDto, Entrust vo, Integer type) {
        if (type == 1) {
            vo.setReceiverId(SecurityUtils.getLogInEmpIdSafe());
        }
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        List<Entrust> resultData = ((UserEntrustMapper)this.getBaseMapper()).getEntrustPageList(page, vo.getReceiverId());
        if (resultData == null) {
            return PageUtils.getResultAndPage((Page)page);
        }
        page.setRecords(resultData);
        return PageUtils.getResultAndPage((Page)page);
    }

    @Override
    @Transactional
    public void updateEntrustList(DataVo dataVo) {
        for (IdsVo idsVo : dataVo.getIds()) {
            UserEntrust userEntrust = new UserEntrust();
            userEntrust.setUpdateUser(SecurityUtils.getLogInEmpNameSafe());
            userEntrust.setBeginTime(dataVo.getBeginTime());
            userEntrust.setEndTime(dataVo.getEndTime());
            userEntrust.setReceiverId(dataVo.getReceiverId());
            userEntrust.setReceiverName(dataVo.getReceiverName());
            userEntrust.setSender(dataVo.getSender());
            if (idsVo.getId() != null && idsVo.getId() > 0) {
                UserEntrust userEntrustCheck = (UserEntrust)((UserEntrustMapper)this.getBaseMapper()).selectById(idsVo.getId());
                if (userEntrustCheck == null) {
                    throw new AFBizException("300001", "\u66f4\u65b0\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
                }
                userEntrust.setId(idsVo.getId());
                userEntrust.setPowerId(userEntrustCheck.getPowerId());
                userEntrust.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
                ((UserEntrustMapper)this.getBaseMapper()).updateById(userEntrust);
                continue;
            }
            if (idsVo.getPowerId() == null) continue;
            if (userEntrust.getReceiverId() == null) {
                throw new AFBizException("300002", "\u8bf7\u9009\u62e9\u59d4\u6258\u5bf9\u8c61");
            }
            userEntrust.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
            userEntrust.setPowerId(idsVo.getPowerId());
            userEntrust.setTenantId(MultiTenantUtil.getCurrentTenantId());
            ((UserEntrustMapper)this.getBaseMapper()).insert(userEntrust);
        }
    }

    @Override
    public BaseIdTranStruVo getEntrustEmployee(String employeeId, String employeeName, String powerId) {
        if (ObjectUtils.isEmpty((Object)employeeId) || ObjectUtils.isEmpty((Object)powerId)) {
            return BaseIdTranStruVo.builder().id(employeeId).name(employeeName).build();
        }
        BaseIdTranStruVo result = this.getEntrustEmployeeOnly(employeeId, employeeName, powerId);
        return result;
    }

    @Override
    public BaseIdTranStruVo getEntrustEmployeeOnly(String employeeId, String employeeName, String powerId) {
        if (ObjectUtils.isEmpty((Object)employeeId) || ObjectUtils.isEmpty((Object)powerId)) {
            return BaseIdTranStruVo.builder().id(employeeId).name(employeeName).build();
        }
        List list = ((UserEntrustMapper)this.getBaseMapper()).selectList((Wrapper)((LambdaQueryWrapper)AFWrappers.lambdaTenantQuery().eq(UserEntrust::getPowerId, (Object)powerId)).eq(UserEntrust::getSender, (Object)employeeId));
        if (StringUtils.hasText((String)MultiTenantUtil.getCurrentTenantId())) {
            List currentOnes = list.stream().filter(a -> MultiTenantUtil.getCurrentTenantId().equals(a.getTenantId())).collect(Collectors.toList());
            list = CollectionUtils.isEmpty(currentOnes) && !MultiTenantUtil.strictTenantMode() ? list.stream().filter(a -> !StringUtils.hasText((String)a.getTenantId())).collect(Collectors.toList()) : currentOnes;
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (UserEntrust u : list) {
                if (u.getBeginTime() != null && u.getEndTime() != null && new Date().getTime() >= DateUtil.getDayStart((Date)u.getBeginTime()).getTime() && new Date().getTime() <= DateUtil.getDayEnd((Date)u.getEndTime()).getTime()) {
                    return BaseIdTranStruVo.builder().id(u.getReceiverId()).name(u.getReceiverName()).build();
                }
                if (u.getBeginTime() != null && u.getEndTime() == null && new Date().getTime() >= DateUtil.getDayStart((Date)u.getBeginTime()).getTime()) {
                    return BaseIdTranStruVo.builder().id(u.getReceiverId()).name(u.getReceiverName()).build();
                }
                if (u.getBeginTime() == null && u.getEndTime() == null) {
                    return BaseIdTranStruVo.builder().id(u.getReceiverId()).name(u.getReceiverName()).build();
                }
                if (u.getBeginTime() != null || u.getEndTime() == null || new Date().getTime() > DateUtil.getDayStart((Date)u.getEndTime()).getTime()) continue;
                return BaseIdTranStruVo.builder().id(u.getReceiverId()).name(u.getReceiverName()).build();
            }
        }
        return BaseIdTranStruVo.builder().id(employeeId).name(employeeName).build();
    }
}

