/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.UserMessage;
import org.openoa.base.util.PageUtils;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.MailInfo;
import org.openoa.base.vo.MessageInfo;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.base.vo.SendInfo;
import org.openoa.engine.bpmnconf.mapper.UserMessageMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.UserMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserMessageServiceImpl
extends ServiceImpl<UserMessageMapper, UserMessage>
implements UserMessageService {
    private static final Logger log = LoggerFactory.getLogger(UserMessageServiceImpl.class);

    @Override
    public ResultAndPage<UserMessage> page(PageDto pageDto) {
        String userId = SecurityUtils.getLogInEmpIdSafe();
        QueryWrapper wrapper = new QueryWrapper();
        Page page = PageUtils.getPageByPageDto((PageDto)pageDto);
        wrapper.eq((Object)"user_id", (Object)userId);
        wrapper.eq((Object)"del", (Object)0);
        long totalCount = ((UserMessageMapper)this.getBaseMapper()).selectCount((Wrapper)wrapper);
        page.setTotal(totalCount);
        List<UserMessage> dtoList = totalCount > 0L ? ((UserMessageMapper)this.getBaseMapper()).pageList(pageDto, userId) : Collections.EMPTY_LIST;
        return new ResultAndPage(dtoList, PageUtils.getPageDto((Page)page));
    }

    public Boolean deleteByIds(String id) {
        String userId = SecurityUtils.getLogInEmpIdSafe();
        String[] arr = id.trim().split(",");
        return ((UserMessageMapper)this.getBaseMapper()).deleteByIds(arr, userId);
    }

    public Boolean clean() {
        String userId = SecurityUtils.getLogInEmpIdSafe();
        return ((UserMessageMapper)this.getBaseMapper()).clean(userId);
    }

    public Integer isRead(Long id) {
        String userId = SecurityUtils.getLogInEmpIdSafe();
        UserMessage userMessage = new UserMessage();
        userMessage.setId(id);
        userMessage.setIsRead(Boolean.valueOf(true));
        userMessage.setUserId(userId);
        return ((UserMessageMapper)this.getBaseMapper()).updateById(userMessage);
    }

    @Override
    public Integer insertMessage(UserMessage userMessage) {
        return ((UserMessageMapper)this.getBaseMapper()).insert(userMessage);
    }

    @Override
    @Transactional
    public Boolean sendMessageOnly(SendInfo sendInfo) {
        this.insertMessage(sendInfo.getUserMessage());
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setReceiver(sendInfo.getMessageInfo().getReceiver());
        messageInfo.setContent(sendInfo.getMessageInfo().getContent());
        this.sendMessage(messageInfo);
        return true;
    }

    @Override
    public Boolean sendMail(MailInfo mail) {
        return true;
    }

    @Override
    public Boolean sendMessage(MessageInfo messageInfo) {
        return null;
    }

    @Override
    public Boolean sendMessageCode(String phone) {
        return false;
    }

    @Override
    public Long getUnread() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)SecurityUtils.getLogInEmpIdSafe());
        wrapper.eq((Object)"`read`", (Object)0);
        wrapper.eq((Object)"del", (Object)0);
        return ((UserMessageMapper)this.getBaseMapper()).selectCount((Wrapper)wrapper);
    }

    @Override
    public Boolean refreshUnRead() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)SecurityUtils.getLogInEmpIdSafe());
        wrapper.eq((Object)"`read`", (Object)0);
        wrapper.eq((Object)"del", (Object)0);
        List userMessages = ((UserMessageMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        for (UserMessage userMessage : userMessages) {
            userMessage.setIsRead(Boolean.valueOf(true));
            ((UserMessageMapper)this.getBaseMapper()).updateById(userMessage);
        }
        return true;
    }

    @Override
    public void refreshUnRead(Serializable id) {
        ((UserMessageMapper)this.getBaseMapper()).updateById(UserMessage.builder().id(Long.valueOf(Long.parseLong(id.toString()))).isRead(Boolean.valueOf(true)).build());
    }

    public void readNode(String node) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"node", (Object)node);
        List userMessages = ((UserMessageMapper)this.getBaseMapper()).selectList((Wrapper)wrapper);
        for (UserMessage userMessage : userMessages) {
            userMessage.setIsRead(Boolean.valueOf(true));
            ((UserMessageMapper)this.getBaseMapper()).updateById(userMessage);
        }
    }

    @Override
    public void cleanUserMessage(String beforeDate) {
        ((UserMessageMapper)this.getBaseMapper()).cleanUserMessage(beforeDate);
    }
}

