/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.BpmnConfFlagsEnum;
import org.openoa.base.entity.BpmnNodeLabel;
import org.openoa.base.service.AntFlowOrderPostProcessor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.engine.bpmnconf.service.biz.BpmNodeLabelsServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NodeLabelsPostProcessor
implements AntFlowOrderPostProcessor<BpmnConfVo> {
    @Autowired
    private BpmNodeLabelsServiceImpl nodeLabelsService;

    public void postProcess(BpmnConfVo confVo) {
        List nodeVos = confVo.getNodes();
        ArrayList nodeLabels = new ArrayList();
        for (BpmnNodeVo nodeVo : nodeVos) {
            List labelList = nodeVo.getLabelList();
            if (CollectionUtils.isEmpty((Collection)labelList)) continue;
            List labels = labelList.stream().map(a -> {
                Long nodeId = nodeVo.getId();
                BpmnNodeLabel nodeLabel = new BpmnNodeLabel();
                nodeLabel.setNodeId(nodeId);
                nodeLabel.setLabelName(a.getLabelName());
                nodeLabel.setLabelValue(a.getLabelValue());
                nodeLabel.setCreateUser(SecurityUtils.getLogInEmpName());
                return nodeLabel;
            }).collect(Collectors.toList());
            nodeLabels.addAll(labels);
        }
        if (!CollectionUtils.isEmpty(nodeLabels)) {
            Integer extraFlags = confVo.getExtraFlags();
            Integer binariedOr = BpmnConfFlagsEnum.binaryOr((Integer)extraFlags, (Integer)BpmnConfFlagsEnum.HAS_NODE_LABELS.getCode());
            confVo.setExtraFlags(binariedOr);
            this.nodeLabelsService.saveBatch(nodeLabels);
        }
    }

    public int order() {
        return 1;
    }
}

