/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.service.tagparser;

import java.util.Collection;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.factory.TagParser;

public class FormOperationTagParser
implements TagParser<ProcessOperationAdaptor, BusinessDataVo> {
    @Override
    public ProcessOperationAdaptor parseTag(BusinessDataVo data) {
        if (data == null) {
            throw new AFBizException("provided data to find a processing method is null");
        }
        Integer operationType = data.getOperationType();
        Boolean isOutSideAccessProc = data.getIsOutSideAccessProc();
        if (operationType == null) {
            throw new AFBizException("provided data has no property of operationType!");
        }
        ProcessOperationEnum poEnum = ProcessOperationEnum.getEnumByCode((Integer)operationType);
        if (poEnum == null) {
            throw new AFBizException("can not find a processing method by providing data with your given operationType of" + operationType);
        }
        Collection processOperationAdaptors = SpringBeanUtils.getBeans(ProcessOperationAdaptor.class);
        for (ProcessOperationAdaptor processOperationAdaptor : processOperationAdaptors) {
            Integer outSideType;
            String outSideMarker;
            if (!(isOutSideAccessProc == false ? processOperationAdaptor.isSupportBusinessObject((Enum)poEnum) : processOperationAdaptor.isSupportBusinessObject(outSideMarker = (outSideType = data.getOutSideType()) == 0 ? ProcessOperationEnum.getOutSideMarker() : ProcessOperationEnum.getOutSideAccessmarker(), (Enum)poEnum))) continue;
            return processOperationAdaptor;
        }
        return null;
    }
}

