/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.aspect;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.openoa.base.constant.enums.ProcessNodeEnum;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.entity.OutSideBpmBusinessParty;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.vo.BpmVariableMessageVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.biz.BpmnConfBizServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmBusinessPartyServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmCallbackUrlConfServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableMessageBizService;
import org.openoa.engine.factory.IAdaptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
public class BpmnSendMessageAspect {
    private static final Logger log = LoggerFactory.getLogger(BpmnSendMessageAspect.class);
    @Autowired
    private BpmVariableMessageBizService bpmVariableMessageBizService;
    @Autowired
    private BpmnConfBizServiceImpl bpmnConfCommonService;
    @Autowired
    private OutSideBpmBusinessPartyServiceImpl outSideBpmBusinessPartyService;
    @Autowired
    @Lazy
    private OutSideBpmCallbackUrlConfServiceImpl outSideBpmCallbackUrlConfService;
    @Autowired
    private IAdaptorFactory adaptorFactory;

    @Around(value="execution(* org.openoa.base.interf.ProcessOperationAdaptor.doProcessButton(..))")
    public void around(ProceedingJoinPoint joinPoint) throws Throwable {
        BpmVariableMessageVo vo;
        BusinessDataVo businessDataVo = this.getBusinessDataVo(joinPoint.getArgs());
        if (businessDataVo == null) {
            throw new AFBizException("\u5165\u53c2\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4f60\u7684\u53c2\u6570\uff01");
        }
        BpmnConf bpmnConf = this.bpmnConfCommonService.getBpmnConfByFormCode(businessDataVo.getFormCode());
        if (ObjectUtils.isEmpty((Object)bpmnConf) || ObjectUtils.isEmpty((Object)bpmnConf.getId())) {
            throw new AFBizException("\u8868\u5355\u7f16\u53f7[" + businessDataVo.getFormCode() + "]\u672a\u5339\u914d\u5230\u5de5\u4f5c\u6d41\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u6216\u5de5\u4f5c\u6d41\u76f8\u5173\u914d\u7f6e");
        }
        if (bpmnConf.getIsOutSideProcess() == 1) {
            businessDataVo.setIsOutSideAccessProc(Boolean.valueOf(true));
        }
        Long businessPartyId = bpmnConf.getBusinessPartyId();
        OutSideBpmBusinessParty outSideBpmBusinessParty = null;
        if (businessPartyId != null) {
            outSideBpmBusinessParty = (OutSideBpmBusinessParty)this.outSideBpmBusinessPartyService.getById(bpmnConf.getBusinessPartyId());
            businessDataVo.setOutSideType(outSideBpmBusinessParty.getType());
        }
        if (outSideBpmBusinessParty == null) {
            outSideBpmBusinessParty = new OutSideBpmBusinessParty();
        }
        BpmnConfVo bpmnConfVo = Optional.of(bpmnConf).map(o -> {
            BpmnConfVo bcVo = new BpmnConfVo();
            BeanUtils.copyProperties((Object)o, (Object)bcVo);
            return bcVo;
        }).orElse(new BpmnConfVo());
        businessDataVo.setBpmnConfVo(bpmnConfVo);
        if (!ObjectUtils.isEmpty((Object)businessDataVo.getFormData())) {
            bpmnConfVo.setFormData(businessDataVo.getFormData());
        }
        businessDataVo.setBpmnCode(bpmnConf.getBpmnCode());
        businessDataVo.setBpmnName(bpmnConf.getBpmnName());
        if (businessDataVo.getOperationType().equals(ProcessOperationEnum.BUTTON_TYPE_SUBMIT.getCode())) {
            this.doMethod(bpmnConf, businessDataVo, outSideBpmBusinessParty, ProcessOperationEnum.BUTTON_TYPE_SUBMIT, joinPoint);
            vo = this.bpmVariableMessageBizService.fromBusinessDataVo(businessDataVo);
            vo.setElementId(ProcessNodeEnum.START_TASK_KEY.getDesc());
        } else {
            vo = this.bpmVariableMessageBizService.fromBusinessDataVo(businessDataVo);
            ProcessOperationEnum processOperationEunm = ProcessOperationEnum.getEnumByCode((Integer)businessDataVo.getOperationType());
            this.doMethod(bpmnConf, businessDataVo, outSideBpmBusinessParty, processOperationEunm, joinPoint);
        }
        if (!ObjectUtils.isEmpty((Object)vo)) {
            businessDataVo.setIsLowCodeFlow(bpmnConfVo.getIsLowCodeFlow());
            if (bpmnConf.getIsOutSideProcess() == 1) {
                vo.setIsOutside(Boolean.valueOf(true));
                businessDataVo.setIsOutSideAccessProc(Boolean.valueOf(true));
            }
            this.bpmVariableMessageBizService.sendTemplateMessagesAsync(vo);
        }
    }

    private BusinessDataVo getBusinessDataVo(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof BusinessDataVo)) continue;
            return (BusinessDataVo)arg;
        }
        return null;
    }

    private void doMethod(BpmnConf bpmnConf, BusinessDataVo businessDataVo, OutSideBpmBusinessParty outSideBpmBusinessParty, ProcessOperationEnum processOperationEunm, ProceedingJoinPoint joinPoint) throws Throwable {
        if (bpmnConf.getIsOutSideProcess() == 1 && !businessDataVo.getIsOutSideChecked().booleanValue()) {
            businessDataVo.setOutSideType(Integer.valueOf(2));
            ProcessOperationAdaptor bean = this.adaptorFactory.getProcessOperation(businessDataVo);
            if (bean == null) {
                throw new AFBizException(StringUtils.join((Object[])new String[]{processOperationEunm.getDesc(), "\u529f\u80fd\u5b9e\u73b0\u672a\u5339\u914d\uff0c\u65b9\u6cd5\u6267\u884c\u5931\u8d25\uff01"}));
            }
            businessDataVo.setIsOutSideChecked(Boolean.valueOf(true));
            bean.doProcessButton(businessDataVo);
        } else {
            joinPoint.proceed(new Object[]{businessDataVo});
        }
    }
}

