/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.ThreadLocalContainer;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.biz.ButtonOperationServiceImpl;
import org.openoa.engine.factory.FormFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
public class DoButtonOperationAspect {
    private static final Logger log = LoggerFactory.getLogger(DoButtonOperationAspect.class);
    @Autowired
    private FormFactory formFactory;
    @Autowired
    private ButtonOperationServiceImpl buttonOperationService;

    @Around(value="execution(* org.openoa.engine.factory.ButtonPreOperationService.buttonsPreOperation(..))")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        if (args.length != 2) {
            throw new IllegalArgumentException("method must hava two parameters");
        }
        String params = (String)args[0];
        String formCode = (String)args[1];
        log.info("params:{},formCode:{}", (Object)params, (Object)formCode);
        BusinessDataVo vo = this.formFactory.dataFormConversion(params, formCode);
        ProcessOperationEnum poEnum = ProcessOperationEnum.getEnumByCode((Integer)vo.getOperationType());
        if (ObjectUtils.isEmpty((Object)poEnum)) {
            throw new AFBizException("unknown operation type,please Contact the Administrator");
        }
        formCode = vo.getFormCode();
        ThreadLocalContainer.set((String)"form_code", (Object)formCode);
        if (poEnum.getCode().equals(ProcessOperationEnum.BUTTON_TYPE_DIS_AGREE.getCode()) || poEnum.getCode().equals(ProcessOperationEnum.BUTTON_TYPE_STOP.getCode())) {
            vo.setFlag(Boolean.valueOf(false));
        } else if (poEnum.getCode().equals(ProcessOperationEnum.BUTTON_TYPE_ABANDON.getCode())) {
            vo.setFlag(Boolean.valueOf(true));
        }
        if (ObjectUtils.isEmpty((Object)vo.getStartUserId())) {
            vo.setStartUserId(SecurityUtils.getLogInEmpIdStr());
            vo.setStartUserName(SecurityUtils.getLogInEmpName());
        }
        return this.buttonOperationService.buttonsOperationTransactional(vo);
    }
}

