/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.activitilistener.WorkflowButtonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class FormOperationFinishAspect {
    private static final Logger log = LoggerFactory.getLogger(FormOperationFinishAspect.class);
    @Autowired
    private WorkflowButtonHandler workflowButtonHandler;

    @Around(value="execution(* org.openoa.base.interf.ProcessFinishListener+.finishData(..))")
    public Object aroundFinishData(ProceedingJoinPoint joinPoint) throws Throwable {
        String className = joinPoint.getTarget().getClass().getSimpleName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        if (args.length != 1 || !(args[0] instanceof BusinessDataVo)) {
            log.error("[FormOperationFinishAspect] \u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u7c7b\u540d\uff1a{} \u65b9\u6cd5\uff1a{}", (Object)className, (Object)methodName);
            throw new IllegalArgumentException("finishData \u53c2\u6570\u975e\u6cd5\uff0c\u5fc5\u987b\u662f BusinessDataVo \u7c7b\u578b");
        }
        this.workflowButtonHandler.onFinishData((BusinessDataVo)args[0]);
        log.info("[FormOperationFinishAspect] >>> {}.{} \u5f00\u59cb\u6267\u884c", (Object)className, (Object)methodName);
        long start = System.currentTimeMillis();
        try {
            Object result = joinPoint.proceed();
            log.info("[FormOperationFinishAspect] <<< {}.{} \u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6 {} ms", new Object[]{className, methodName, System.currentTimeMillis() - start});
            return result;
        }
        catch (Throwable t) {
            log.error("[FormOperationFinishAspect] !!! {}.{} \u6267\u884c\u5f02\u5e38: {}", new Object[]{className, methodName, t.getMessage(), t});
            throw t;
        }
    }
}

