/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.aspect;

import java.util.Arrays;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.openoa.base.constant.enums.OpLogFlagEnum;
import org.openoa.base.entity.OpLog;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.EnvUtil;
import org.openoa.base.util.JimuJsonUtil;
import org.openoa.base.util.MDCLogUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.SignatureRequest;
import org.openoa.engine.bpmnconf.service.impl.OpLogServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamSource;

public class HttpLogAspect {
    private static final Logger log = LoggerFactory.getLogger(HttpLogAspect.class);
    @Autowired
    private OpLogServiceImpl opLogServiceImpl;

    @Pointcut(value="@within(org.springframework.stereotype.Controller) ||@within(org.springframework.web.bind.annotation.RestController)&&!@annotation(org.openoa.base.interf.anno.IgnoreLog)&&!@within(org.openoa.base.interf.anno.IgnoreLog)&&within(org.openoa..*)")
    public void httpAspect() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="httpAspect()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        String respStr;
        String reqStr;
        Object object;
        long startTime = System.currentTimeMillis();
        OpLogFlagEnum flagEnum = OpLogFlagEnum.SUCCESS;
        Object resp = null;
        try {
            object = resp = joinPoint.proceed();
            reqStr = "@IgnoreLog";
            respStr = "@IgnoreLog";
        }
        catch (Throwable throwable) {
            try {
                flagEnum = throwable instanceof AFBizException ? OpLogFlagEnum.BusinessException : OpLogFlagEnum.FAILURE;
                resp = throwable.getClass().getSimpleName() + " : " + throwable.getMessage();
                throw throwable;
            }
            catch (Throwable throwable2) {
                String reqStr2 = "@IgnoreLog";
                String respStr2 = "@IgnoreLog";
                try {
                    String className = joinPoint.getTarget().getClass().getName();
                    String methodName = joinPoint.getSignature().getName();
                    if (!HttpLogAspect.isIgnoreLog(joinPoint)) {
                        reqStr2 = JimuJsonUtil.toJsonString((Object)HttpLogAspect.checkArgs(joinPoint.getArgs()));
                        respStr2 = JimuJsonUtil.toJsonString((Object)resp);
                    }
                    long useTime = System.currentTimeMillis() - startTime;
                    SignatureRequest signatureReq = EnvUtil.getSignatureReq();
                    OpLog opLog = OpLog.builder().msgId(MDCLogUtil.getLogId()).opFlag(flagEnum.getCode()).opUserName(SecurityUtils.getLogInEmpNameSafe()).opMethod(String.format("%s_%s", className, methodName)).opParam(reqStr2).opResult(respStr2).systemType(signatureReq.getSystemType()).systemVersion(signatureReq.getSystemVersion()).appVersion(signatureReq.getAppVersion()).hardware(signatureReq.getHardware()).remark("\u64cd\u4f5c\u65e5\u5fd7").opTime(new Date()).opUseTime(Long.valueOf(useTime)).build();
                    this.opLogServiceImpl.asyncInsert(opLog);
                    throw throwable2;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                throw throwable2;
            }
        }
        try {
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            if (!HttpLogAspect.isIgnoreLog(joinPoint)) {
                reqStr = JimuJsonUtil.toJsonString((Object)HttpLogAspect.checkArgs(joinPoint.getArgs()));
                respStr = JimuJsonUtil.toJsonString((Object)resp);
            }
            long useTime = System.currentTimeMillis() - startTime;
            SignatureRequest signatureReq = EnvUtil.getSignatureReq();
            OpLog opLog = OpLog.builder().msgId(MDCLogUtil.getLogId()).opFlag(flagEnum.getCode()).opUserName(SecurityUtils.getLogInEmpNameSafe()).opMethod(String.format("%s_%s", className, methodName)).opParam(reqStr).opResult(respStr).systemType(signatureReq.getSystemType()).systemVersion(signatureReq.getSystemVersion()).appVersion(signatureReq.getAppVersion()).hardware(signatureReq.getHardware()).remark("\u64cd\u4f5c\u65e5\u5fd7").opTime(new Date()).opUseTime(Long.valueOf(useTime)).build();
            this.opLogServiceImpl.asyncInsert(opLog);
            return object;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return object;
    }

    private static boolean isIgnoreLog(ProceedingJoinPoint joinPoint) {
        return false;
    }

    private static Object[] checkArgs(Object ... args) {
        Object[] result = Arrays.copyOf(args, args.length);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] instanceof ServletRequest) {
                result[i] = "req";
            }
            if (result[i] instanceof ServletResponse) {
                result[i] = "resp";
            }
            if (!(result[i] instanceof InputStreamSource)) continue;
            result[i] = "stream";
        }
        return result;
    }

    @AfterThrowing(pointcut="httpAspect()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Throwable e) {
        OpLogFlagEnum flagEnum;
        OpLogFlagEnum opLogFlagEnum = flagEnum = e instanceof AFBizException ? OpLogFlagEnum.BusinessException : OpLogFlagEnum.FAILURE;
        if (flagEnum.equals((Object)OpLogFlagEnum.FAILURE)) {
            // empty if block
        }
    }
}

