/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.aspect;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.openoa.base.exception.AFBizException;
import org.openoa.engine.lowflow.service.LFFormOperationAdaptor;
import org.openoa.engine.lowflow.vo.UDLFApplyVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class LowFlowApprovalServiceAspect {
    private static final Logger log = LoggerFactory.getLogger(LowFlowApprovalServiceAspect.class);
    @Autowired(required=false)
    private List<LFFormOperationAdaptor> lfFormOperationAdaptors;

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.previewSetCondition(..))")
    public Object aroundPreviewSetCondition(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "previewSetCondition");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.initData(..))")
    public Object aroundInitData(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "initData");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.launchParameters(..))")
    public Object aroundLaunchParameters(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "launchParameters");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.queryData(..))")
    public Object aroundQueryData(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "queryData");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.submitData(..))")
    public Object aroundSubmitData(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "submitData");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.consentData(..))")
    public Object aroundConsentData(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "consentData");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.backToModifyData(..))")
    public Object aroundBackToModifyData(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "backToModifyData");
    }

    @Around(value="execution(* org.openoa.engine.lowflow.service.LowFlowApprovalService.cancellationData(..))")
    public Object aroundCancellationData(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.logAndProceed(joinPoint, "cancellationData");
    }

    private Object logAndProceed(ProceedingJoinPoint joinPoint, String methodName) throws Throwable {
        log.info("[LowFlowAOP] >>> \u8c03\u7528\u65b9\u6cd5: {}", (Object)methodName);
        long start = System.currentTimeMillis();
        try {
            Object[] args = joinPoint.getArgs();
            if (args.length > 1) {
                throw new AFBizException("\u5207\u9762\u65b9\u6cd5\u9519\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            }
            UDLFApplyVo arg = (UDLFApplyVo)((Object)args[0]);
            if (CollectionUtils.isEmpty(this.lfFormOperationAdaptors)) {
                this.lfFormOperationAdaptors = new ArrayList<LFFormOperationAdaptor>();
            }
            for (LFFormOperationAdaptor lfFormOperationAdaptor : this.lfFormOperationAdaptors) {
                if ("queryData".equals(methodName)) {
                    lfFormOperationAdaptor.queryData(arg);
                }
                if ("submitData".equals(methodName)) {
                    lfFormOperationAdaptor.submitData(arg);
                }
                if ("consentData".equals(methodName)) {
                    lfFormOperationAdaptor.consentData(arg);
                }
                if ("initData".equals(methodName)) {
                    lfFormOperationAdaptor.initData(arg);
                }
                if ("previewSetCondition".equals(methodName)) {
                    lfFormOperationAdaptor.previewSetCondition(arg);
                }
                if ("launchParameters".equals(methodName)) {
                    lfFormOperationAdaptor.launchParameters(arg);
                }
                if ("backToModifyData".equals(methodName)) {
                    lfFormOperationAdaptor.backToModifyData(arg);
                }
                if (!"cancellationData".equals(methodName)) continue;
                lfFormOperationAdaptor.cancellationData(arg);
            }
            Object result = joinPoint.proceed();
            log.info("[LowFlowAOP] <<< \u65b9\u6cd5 {} \u6267\u884c\u5b8c\u6210\uff0c\u8017\u65f6 {}ms", (Object)methodName, (Object)(System.currentTimeMillis() - start));
            return result;
        }
        catch (Throwable t) {
            log.error("[LowFlowAOP] !!! \u65b9\u6cd5 {} \u629b\u51fa\u5f02\u5e38: {}", new Object[]{methodName, t.getMessage(), t});
            throw t;
        }
    }
}

