/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.async;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.openoa.engine.conf.async.AsyncTaskDecorator;
import org.openoa.engine.conf.confval.AsyncProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
@ConditionalOnExpression(value="${async.enabled:true}")
@EnableConfigurationProperties(value={AsyncProperties.class})
public class AsyncConfiguration
implements AsyncConfigurer {
    private static Logger logger = LoggerFactory.getLogger(AsyncConfiguration.class);
    @Autowired
    private AsyncProperties properties;

    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.properties.getCorePoolSize());
        executor.setMaxPoolSize(this.properties.getMaxPoolSize());
        executor.setQueueCapacity(this.properties.getQueueCapacity());
        executor.setThreadNamePrefix(this.properties.getThreadNamePrefix());
        executor.setKeepAliveSeconds(this.properties.getKeepAliveSeconds().intValue());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(this.properties.getAwaitTerminationSeconds().intValue());
        executor.setTaskDecorator((TaskDecorator)new AsyncTaskDecorator());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return TtlExecutors.getTtlExecutor((Executor)executor);
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (throwable, method, objects) -> logger.error(String.format("=========>\u8c03\u7528\u5f02\u6b65\u4efb\u52a1\u51fa\u9519\u4e86 method: %s ", method.getName()), throwable);
    }
}

