/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.async;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class AsyncTaskDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        Map contextMap = MDC.getCopyOfContextMap();
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        return () -> {
            try {
                RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                if (contextMap != null) {
                    MDC.setContextMap((Map)contextMap);
                } else {
                    MDC.clear();
                }
                runnable.run();
            }
            finally {
                MDC.clear();
                RequestContextHolder.resetRequestAttributes();
            }
        };
    }
}

