/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.config;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.openoa.base.interf.ActivitiServiceAnno;
import org.openoa.engine.conf.config.SdpAnnotationBeanNameGenerator;
import org.openoa.engine.conf.register.CustomAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;

@Configuration
public class CustomAnnotationConfigurer
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(CustomAnnotationConfigurer.class);
    private ApplicationContext applicationContext;
    public static Map<String, String> activitiServiceMap = Maps.newHashMap();
    private String[] scanPackages;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        this.scanPackages = configurableListableBeanFactory.resolveEmbeddedValue("${antflow.common.scan-packages:org.openoa}").split(",");
        this.scanningAndAssemblingAnnotation(configurableListableBeanFactory, ActivitiServiceAnno.class, activitiServiceMap, "\u542f\u52a8\u626b\u63cf\u5e76\u88c5\u914d\u626b\u63cf\u6807\u6ce8\u6709@ActivitiServiceAnno\u6ce8\u89e3bean\u5b9e\u73b0\u7c7b\u5931\u8d25");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void scanningAndAssemblingAnnotation(ConfigurableListableBeanFactory beanFactory, Class<? extends Annotation> clazz, Map<String, String> map, String errorMsg) {
        Set<BeanDefinitionHolder> beanDefinitionHolders = this.getBeanDefinitionHolders(beanFactory, clazz);
        if (CollectionUtils.isEmpty(beanDefinitionHolders)) {
            return;
        }
        beanDefinitionHolders.forEach(o -> {
            try {
                this.configureBean((BeanDefinitionHolder)o);
                Class<?> cls = Class.forName(o.getBeanDefinition().getBeanClassName());
                Object annotation = cls.getAnnotation(clazz);
                Method method = annotation.getClass().getMethod("svcName", new Class[0]);
                Object svcName = method.invoke(annotation, new Object[0]);
                if (svcName != null) {
                    map.put(svcName.toString(), o.getBeanName());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error(errorMsg, (Throwable)e);
            }
        });
    }

    private void configureBean(BeanDefinitionHolder o) {
        ScannedGenericBeanDefinition beanDefinition = (ScannedGenericBeanDefinition)o.getBeanDefinition();
        AnnotationMetadata metadataVisitor = beanDefinition.getMetadata();
        this.applicationContext.getAutowireCapableBeanFactory().configureBean((Object)o.getBeanDefinition(), o.getBeanName());
    }

    private Set<BeanDefinitionHolder> getBeanDefinitionHolders(ConfigurableListableBeanFactory beanFactory, Class<? extends Annotation> clazz) {
        CustomAnnotationScanner activitiAnnoScanner = CustomAnnotationScanner.getScanner((BeanDefinitionRegistry)beanFactory, clazz);
        activitiAnnoScanner.setResourceLoader((ResourceLoader)this.applicationContext);
        activitiAnnoScanner.setBeanNameGenerator((BeanNameGenerator)new SdpAnnotationBeanNameGenerator());
        return activitiAnnoScanner.doScanPackages(this.scanPackages);
    }
}

