/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.openoa.base.exception.AFBizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class RestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start();
        ClientHttpResponse execute = clientHttpRequestExecution.execute(httpRequest, bytes);
        watch.stop();
        long totalTimeMillis = watch.getTotalTimeMillis();
        this.intermediateProcessRequest(httpRequest, bytes);
        this.intermediateProcessResponse(execute, totalTimeMillis);
        return execute;
    }

    private String getRequestBody(byte[] body) throws UnsupportedEncodingException {
        if (body != null && body.length > 0) {
            return new String(body, StandardCharsets.UTF_8);
        }
        return null;
    }

    private void intermediateProcessRequest(HttpRequest request, byte[] body) throws IOException {
        log.info("request method : " + request.getMethod() + " request body : " + this.getRequestBody(body));
    }

    private void intermediateProcessResponse(ClientHttpResponse response, long totalMils) throws IOException {
        String body = this.getBodyString(response);
        HttpStatus statusCode = response.getStatusCode();
        double totalSeconds = (double)totalMils / 1000.0;
        log.info("response status code:{} response status text:{},\u8bf7\u6c42\u8017\u65f6:{}, response body :{}", new Object[]{response.getStatusCode(), response.getStatusText(), totalSeconds, body});
        if (HttpStatus.TOO_MANY_REQUESTS == statusCode) {
            throw new AFBizException("\u8bf7\u6c42\u9650\u6d41");
        }
    }

    private String getBodyString(ClientHttpResponse response) throws IOException {
        try {
            if (response != null && response.getBody() != null) {
                StringBuilder inputStringBuilder = new StringBuilder();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getBody(), StandardCharsets.UTF_8));
                String line = bufferedReader.readLine();
                while (line != null) {
                    inputStringBuilder.append(line);
                    inputStringBuilder.append('\n');
                    line = bufferedReader.readLine();
                }
                return inputStringBuilder.toString();
            }
            return null;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

