/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.engineconfig;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.openoa.base.exception.AFBizException;
import org.springframework.boot.jdbc.DatabaseDriver;

public class DefaultDataBaseTypeDetector {
    public static String detectDataSourceDbType(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String databaseProductName = metaData.getDatabaseProductName();
            DatabaseDriver databaseDriver = DatabaseDriver.fromProductName((String)databaseProductName);
            String dbName = DefaultDataBaseTypeDetector.mapDatabaseType(databaseDriver);
            return dbName;
        }
        catch (SQLException e) {
            throw new AFBizException("can not get database produce name" + e.getMessage());
        }
    }

    private static String mapDatabaseType(DatabaseDriver databaseDriver) {
        switch (databaseDriver) {
            case MYSQL: 
            case MARIADB: {
                return "mysql";
            }
            case POSTGRESQL: {
                return "postgres";
            }
            case ORACLE: {
                return "oracle";
            }
            case H2: {
                return "h2";
            }
            case DB2: {
                return "db2";
            }
        }
        throw new IllegalArgumentException("Unsupported database type: " + databaseDriver);
    }
}

