/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.engineconfig;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.cfg.TransactionContextFactory;
import org.activiti.engine.impl.cfg.multitenant.MultiSchemaMultiTenantProcessEngineConfiguration;
import org.activiti.engine.impl.cfg.multitenant.TenantAwareDataSource;
import org.activiti.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.activiti.spring.SpringAsyncExecutor;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.SpringTransactionContextFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.openoa.engine.bpmnconf.activitilistener.BpmnGlobalEventListener;
import org.openoa.engine.conf.engineconfig.AbstractProcessEngineAutoConfiguration;
import org.openoa.engine.conf.engineconfig.ActivitiProperties;
import org.openoa.engine.conf.engineconfig.DefaultDataBaseTypeDetector;
import org.openoa.engine.conf.engineconfig.MultiTenantInfoHolder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class MultiSchemaMultiTenantDataSourceProcessEngineAutoConfiguration
extends AbstractProcessEngineAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public MultiSchemaMultiTenantProcessEngineConfiguration multiTenantProcessEngineConfiguration(MultiTenantInfoHolder tenantInfoHolder, TenantAwareDataSource tenantAwareDataSource, PlatformTransactionManager transactionManager, SpringAsyncExecutor springAsyncExecutor) {
        MultiSchemaMultiTenantProcessEngineConfiguration configuration = new MultiSchemaMultiTenantProcessEngineConfiguration((TenantInfoHolder)tenantInfoHolder);
        configuration.setDataSource((DataSource)tenantAwareDataSource);
        configuration.setDatabaseType(DefaultDataBaseTypeDetector.detectDataSourceDbType(tenantInfoHolder.getDefaultDataSource()));
        configuration.setDatabaseSchemaUpdate("false");
        configuration.setTransactionsExternallyManaged(true);
        configuration.setAsyncExecutor((AsyncExecutor)springAsyncExecutor);
        configuration.setJobExecutorActivate(false);
        configuration.setActivityFontName("\u5b8b\u4f53");
        configuration.setAnnotationFontName("\u5b8b\u4f53");
        configuration.setLabelFontName("\u5b8b\u4f53");
        configuration.setEventListeners((List)Lists.newArrayList((Object[])new ActivitiEventListener[]{new BpmnGlobalEventListener()}));
        SpringTransactionContextFactory transactionContextFactory = new SpringTransactionContextFactory(transactionManager);
        configuration.setTransactionContextFactory((TransactionContextFactory)transactionContextFactory);
        configuration.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
        Collection<String> allTenants = tenantInfoHolder.getAllTenants();
        for (String currentTenant : allTenants) {
            DataSource dataSource = tenantInfoHolder.getDataSource(currentTenant);
            configuration.registerTenant(currentTenant, dataSource);
        }
        return configuration;
    }

    @Configuration
    @EnableConfigurationProperties(value={ActivitiProperties.class})
    public static class DataSourceProcessEngineConfiguration
    extends AbstractProcessEngineAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SpringProcessEngineConfiguration springProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager transactionManager, SpringAsyncExecutor springAsyncExecutor) throws IOException {
            return this.baseSpringProcessEngineConfiguration(dataSource, transactionManager, springAsyncExecutor);
        }

        @Bean
        @ConditionalOnMissingBean
        public ProcessEngineFactoryBean processEngineFactoryBean(MultiSchemaMultiTenantProcessEngineConfiguration configuration) {
            return super.springProcessEngineBean(configuration);
        }
    }
}

