/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.engineconfig;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.openoa.engine.conf.engineconfig.DataSourceFactory;
import org.openoa.engine.conf.engineconfig.IAntflowDataSourceConfigScanner;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.util.CollectionUtils;

public class TenantDataSourceRegistry
implements InitializingBean {
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private IAntflowDataSourceConfigScanner antflowDataSourceConfigScanner;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    protected final Map<String, DataSource> dataSources = new HashMap<String, DataSource>();

    public void registerDataSource(String name, DataSource dataSource) {
        this.dataSources.put(name, dataSource);
    }

    public DataSource getDataSource(String name) {
        return this.dataSources.getOrDefault(name, this.dataSources.get(""));
    }

    public DataSource getDefaultDataSource() {
        DataSource dataSource = this.dataSources.get("");
        if (dataSource == null) {
            dataSource = this.dataSources.get("default");
        }
        return dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        Map<String, DataSourceProperties> antflowDataSourceProperties = this.antflowDataSourceConfigScanner.getAntflowDataSourceProperties();
        if (!CollectionUtils.isEmpty(antflowDataSourceProperties)) {
            for (String key : antflowDataSourceProperties.keySet()) {
                DataSourceProperties dataSourceProperties = antflowDataSourceProperties.get(key);
                String username = dataSourceProperties.getUsername();
                String password = dataSourceProperties.getPassword();
                String url = dataSourceProperties.getUrl();
                DataSource dataSource = this.dataSourceFactory.createDataSource(url, username, password);
                dataSourceMap.put(key, dataSource);
            }
        }
        if (CollectionUtils.isEmpty(dataSourceMap)) {
            dataSourceMap.put("", this.dataSourceProperties.initializeDataSourceBuilder().build());
        }
        for (String dataSourceName : dataSourceMap.keySet()) {
            DataSource dataSource = (DataSource)dataSourceMap.get(dataSourceName);
            this.registerDataSource(dataSourceName, dataSource);
        }
    }
}

