/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.mvc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.MDCLogUtil;
import org.openoa.base.util.ThreadLocalContainer;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.engine.conf.engineconfig.MultiTenantIdHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@Component
public class JiMuMDCCommonsRequestLoggingFilter
extends CommonsRequestLoggingFilter {
    @Autowired
    private AfUserService userService;
    @Autowired
    private MultiTenantIdHolder tenantIdHolder;

    protected boolean shouldLog(HttpServletRequest request) {
        return true;
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
        MDCLogUtil.resetLogId();
        if (!request.getMethod().equals("OPTIONS")) {
            String userId = request.getHeader("userId");
            String userName = request.getHeader("userName");
            String tenantId = request.getHeader("tenantId");
            String tenantUser = request.getHeader("tenantUser");
            if (!StringUtils.isEmpty((CharSequence)tenantId)) {
                this.tenantIdHolder.setCurrentTenantId(tenantId);
            }
            if (!StringUtils.isEmpty((CharSequence)tenantUser)) {
                ThreadLocalContainer.set((String)"tenantUser", (Object)tenantUser);
            }
            if (!StringUtils.isEmpty((CharSequence)userName)) {
                try {
                    userName = URLDecoder.decode(userName, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (StringUtils.isEmpty((CharSequence)userId)) {
                userId = request.getHeader("Userid");
            }
            if (!StringUtils.isEmpty((CharSequence)userId)) {
                if (!StringUtils.isEmpty((CharSequence)userName)) {
                    BaseIdTranStruVo userInfo = BaseIdTranStruVo.builder().id(userId).name(userName).build();
                    ThreadLocalContainer.set((String)"currentuser", (Object)userInfo);
                } else {
                    BaseIdTranStruVo userById = this.userService.getById(userId);
                    if (userById != null && StringUtils.isEmpty((CharSequence)userName)) {
                        userName = userById.getName();
                        BaseIdTranStruVo userInfo = BaseIdTranStruVo.builder().id(userId).name(userName).build();
                        ThreadLocalContainer.set((String)"currentuser", (Object)userInfo);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.info((Object)"\u5f00\u59cb\u8f93\u51fa\u8be6\u7ec6\u65e5\u5fd7");
                        super.beforeRequest(request, message);
                    }
                }
            }
            if (!StringUtils.isEmpty((CharSequence)userName)) {
                ThreadLocalContainer.set((String)"userName", (Object)userName);
            }
            if (!StringUtils.isEmpty((CharSequence)userId)) {
                ThreadLocalContainer.set((String)"userId", (Object)userId);
            }
        }
    }

    protected void afterRequest(HttpServletRequest request, String message) {
        ThreadLocalContainer.clean();
        if (this.logger.isDebugEnabled()) {
            super.afterRequest(request, message);
        }
    }

    protected boolean isIncludeHeaders() {
        return this.logger.isDebugEnabled() || super.isIncludeHeaders();
    }

    protected boolean isIncludeQueryString() {
        return this.logger.isDebugEnabled() || super.isIncludeQueryString();
    }

    protected boolean isIncludePayload() {
        return this.logger.isDebugEnabled() || super.isIncludePayload();
    }

    protected boolean isIncludeClientInfo() {
        return this.logger.isDebugEnabled() || super.isIncludeClientInfo();
    }
}

