/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.mvc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class MVCRequestWrapped
extends HttpServletRequestWrapper {
    private byte[] bytes;
    private WrappedServletInputStream wrappedServletInputStream;

    public MVCRequestWrapped(HttpServletRequest request) throws IOException {
        super(request);
        this.bytes = IOUtils.toByteArray((InputStream)request.getInputStream());
        String params = new String(this.bytes, "UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bytes);
        this.wrappedServletInputStream = new WrappedServletInputStream(byteArrayInputStream);
        this.reWriteInputStream();
    }

    public void reWriteInputStream() {
        this.wrappedServletInputStream.setStream(new ByteArrayInputStream(this.bytes != null ? this.bytes : new byte[]{}));
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.wrappedServletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.wrappedServletInputStream)));
    }

    public String getRequestParams() throws IOException {
        return new String(this.bytes, this.getCharacterEncoding());
    }

    private class WrappedServletInputStream
    extends ServletInputStream {
        private InputStream sourceStream;
        private boolean finished = false;

        public WrappedServletInputStream(InputStream stream) {
            this.sourceStream = stream;
        }

        public final InputStream getSourceStream() {
            return this.sourceStream;
        }

        public void setStream(InputStream stream) {
            this.sourceStream = stream;
        }

        public int available() throws IOException {
            return this.sourceStream.available();
        }

        public void close() throws IOException {
            super.close();
            this.sourceStream.close();
        }

        public int read() throws IOException {
            int data = this.sourceStream.read();
            if (data == -1) {
                this.finished = true;
            }
            return data;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

