/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.conf.mybatis.interceptor;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import net.sf.jsqlparser.util.deparser.SelectDeParser;
import net.sf.jsqlparser.util.validation.validator.OrderByValidator;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.lowflow.entity.LFMain;
import org.openoa.engine.lowflow.entity.LFMainField;
import org.openoa.engine.utils.ConsistentHashingAlg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class LFConsistentHashingRoutingSqlInterceptor
implements Interceptor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LFConsistentHashingRoutingSqlInterceptor.class);
    @Value(value="${lf.main.table.count:1}")
    private Integer mainTableCount;
    @Value(value="${lf.field.table.count:1}")
    private Integer fieldTableCount;
    private ConsistentHashingAlg mainTableHashing;
    private ConsistentHashingAlg fieldTableHashing;
    private static final List<String> LF_TABLE_NAMES = Lists.newArrayList((Object[])new String[]{"t_lf_main", "t_lf_main_field"});
    private static final List<String> FORM_CODES_UPPER = Lists.newArrayList((Object[])new String[]{"form_code".toUpperCase(), "formCode".toUpperCase()});

    public Object intercept(Invocation invocation) throws Throwable {
        Object parameterObject;
        if (this.mainTableCount < 2) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject = args[1]);
        String sql = boundSql.getSql();
        if (!sql.contains("t_lf_main") && !sql.contains("t_lf_main_field")) {
            return invocation.proceed();
        }
        List<String> tableNames = this.getTableNames(sql);
        if (CollectionUtils.containsAny(LF_TABLE_NAMES, tableNames)) {
            String restoredFormCode = this.restoreFormCodeValueFromSql(sql, boundSql);
            String modifiedSql = "";
            for (String tableName : tableNames) {
                String newTblName;
                if (tableName.equalsIgnoreCase("t_lf_main")) {
                    newTblName = this.mainTableHashing.getServer(restoredFormCode);
                    modifiedSql = LFConsistentHashingRoutingSqlInterceptor.replaceTableName(tableName, newTblName, sql);
                    continue;
                }
                if (!tableName.equalsIgnoreCase("t_lf_main_field")) continue;
                newTblName = this.fieldTableHashing.getServer(restoredFormCode);
                String tmpSql = StringUtils.hasText((String)modifiedSql) ? modifiedSql : sql;
                modifiedSql = LFConsistentHashingRoutingSqlInterceptor.replaceTableName(tableName, newTblName, tmpSql);
            }
            BoundSql newBoundSql = new BoundSql(mappedStatement.getConfiguration(), modifiedSql, boundSql.getParameterMappings(), boundSql.getParameterObject());
            MappedStatement newMappedStatement = this.copyMappedStatement(mappedStatement, newBoundSql);
            args[0] = newMappedStatement;
        }
        return invocation.proceed();
    }

    private MappedStatement copyMappedStatement(MappedStatement ms, BoundSql newBoundSql) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), parameterObject -> newBoundSql, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties() == null ? new String[]{} : ms.getKeyProperties()));
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private String restoreFormCodeValueFromSql(String sql, BoundSql boundSql) {
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        if (parameterMappings == null || parameterMappings.isEmpty() || parameterObject == null) {
            return "";
        }
        MetaObject metaObject = MetaObject.forObject((Object)parameterObject, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        for (ParameterMapping parameterMapping : parameterMappings) {
            String propertyName = parameterMapping.getProperty();
            if ("ID".equalsIgnoreCase(propertyName)) {
                if (parameterObject instanceof LFMain) {
                    return ((LFMain)parameterObject).getFormCode();
                }
                if (parameterObject instanceof LFMainField) {
                    return ((LFMainField)parameterObject).getFormCode();
                }
                BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)((BpmBusinessProcessServiceImpl)((Object)SpringBeanUtils.getBean(BpmBusinessProcessServiceImpl.class))).getOne((Wrapper)Wrappers.lambdaQuery().eq(BpmBusinessProcess::getBusinessId, parameterObject));
                if (bpmBusinessProcess != null) {
                    return bpmBusinessProcess.getProcessinessKey();
                }
                throw new AFBizException("\u65e0\u6cd5\u6839\u636e\u4f4e\u4ee3\u7801\u6d41\u7a0b\u6307\u5b9aId:" + parameterObject + "\u627e\u5230\u6d41\u7a0b\u4fe1\u606f,\u5bf9\u5e94\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728!");
            }
            if (!FORM_CODES_UPPER.contains(propertyName.toUpperCase())) continue;
            Object value = null;
            value = boundSql.hasAdditionalParameter(propertyName) ? boundSql.getAdditionalParameter(propertyName) : (parameterObject instanceof Map ? ((Map)parameterObject).get(propertyName) : metaObject.getValue(propertyName));
            String formattedValue = this.formatParameter(value);
            return formattedValue;
        }
        return "";
    }

    private String formatParameter(Object param) {
        if (param == null) {
            return "NULL";
        }
        if (param instanceof String || param instanceof Date) {
            if (param instanceof Date) {
                return "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(param) + "'";
            }
            return "'" + param.toString().replace("'", "''") + "'";
        }
        return param.toString();
    }

    private List<String> getTableNames(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            return tablesNamesFinder.getTableList(statement);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("\u89e3\u6790 SQL \u51fa\u9519: " + sql, e);
        }
    }

    private static String replaceTableName(String originalTblName, String newTblName, String originalSql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)originalSql);
            if (statement instanceof Select) {
                return LFConsistentHashingRoutingSqlInterceptor.processSelectStatement(originalTblName, newTblName, (Select)statement);
            }
            if (statement instanceof Insert) {
                return LFConsistentHashingRoutingSqlInterceptor.processInsertStatement(originalTblName, newTblName, (Insert)statement);
            }
            if (statement instanceof Update) {
                return LFConsistentHashingRoutingSqlInterceptor.processUpdateStatement(originalTblName, newTblName, (Update)statement);
            }
            if (statement instanceof Delete) {
                return LFConsistentHashingRoutingSqlInterceptor.processDeleteStatement(originalTblName, newTblName, (Delete)statement);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790 SQL \u51fa\u9519: " + originalSql, e);
        }
        return originalSql;
    }

    private static String processSelectStatement(final String originalTblName, final String newTblName, Select select) {
        StringBuilder modifiedSql = new StringBuilder();
        final ExpressionDeParser expressionDeParser = new ExpressionDeParser();
        SelectDeParser selectDeParser = new SelectDeParser((ExpressionVisitor)expressionDeParser, modifiedSql){

            public void visit(Table table) {
                if (table.getName().equalsIgnoreCase(originalTblName)) {
                    table.setName(newTblName);
                }
                super.visit(table);
            }

            public void visit(PlainSelect plainSelect) {
                this.getBuffer().append("SELECT ");
                if (plainSelect.getSelectItems() != null) {
                    List selectItems = plainSelect.getSelectItems();
                    for (int i = 0; i < selectItems.size(); ++i) {
                        ((SelectItem)selectItems.get(i)).accept((SelectItemVisitor)this);
                        if (i >= selectItems.size() - 1) continue;
                        this.getBuffer().append(", ");
                    }
                }
                if (plainSelect.getFromItem() != null) {
                    this.getBuffer().append(" FROM ");
                    plainSelect.getFromItem().accept((FromItemVisitor)this);
                }
                if (plainSelect.getWhere() != null) {
                    this.getBuffer().append(" WHERE ");
                    plainSelect.getWhere().accept((ExpressionVisitor)expressionDeParser);
                }
                if (plainSelect.getGroupBy() != null) {
                    this.getBuffer().append(" GROUP BY ");
                    this.getBuffer().append(plainSelect.getGroupBy());
                }
                if (plainSelect.getOrderByElements() != null) {
                    this.getBuffer().append(" ORDER BY ");
                    plainSelect.getOrderByElements().forEach(orderBy -> {
                        orderBy.accept((OrderByVisitor)new OrderByValidator());
                        this.getBuffer().append(", ");
                    });
                    this.getBuffer().setLength(this.getBuffer().length() - 2);
                }
            }
        };
        expressionDeParser.setSelectVisitor((SelectVisitor)selectDeParser);
        expressionDeParser.setBuffer(modifiedSql);
        select.getSelectBody().accept((SelectVisitor)selectDeParser);
        return modifiedSql.toString();
    }

    private static String processInsertStatement(String originalTblName, String newTblName, Insert insert) {
        Table table = insert.getTable();
        if (table.getName().equalsIgnoreCase(originalTblName)) {
            table.setName(newTblName);
        }
        return insert.toString();
    }

    private static String processUpdateStatement(String originalTblName, String newTblName, Update update) {
        Table table = update.getTable();
        if (table.getName().equalsIgnoreCase(originalTblName)) {
            table.setName(newTblName);
        }
        return update.toString();
    }

    private static String processDeleteStatement(String originalTblName, String newTblName, Delete delete) {
        Table table = delete.getTable();
        if (table.getName().equalsIgnoreCase(originalTblName)) {
            table.setName(newTblName);
        }
        return delete.toString();
    }

    public static List<String> getColumnNamesFromSelectSql(String sql) {
        Select selectStatement;
        SelectBody selectBody;
        ArrayList<String> columnNames = new ArrayList<String>();
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        Statement statement = null;
        try {
            statement = parserManager.parse((Reader)new StringReader(sql));
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        if (statement instanceof Select && (selectBody = (selectStatement = (Select)statement).getSelectBody()) instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            for (SelectItem item : plainSelect.getSelectItems()) {
                if (!(item instanceof SelectExpressionItem)) continue;
                Expression expression = ((SelectExpressionItem)item).getExpression();
                columnNames.addAll(LFConsistentHashingRoutingSqlInterceptor.getColumnNames(expression));
            }
            Expression whereClause = plainSelect.getWhere();
            if (whereClause != null) {
                columnNames.addAll(LFConsistentHashingRoutingSqlInterceptor.getColumnNames(whereClause));
            }
        }
        return columnNames;
    }

    public static List<String> getWhereColumnNamesFromSql(String sql) {
        ArrayList<String> columnNames = new ArrayList<String>();
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        Statement statement = null;
        try {
            statement = parserManager.parse((Reader)new StringReader(sql));
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
        if (statement instanceof Select) {
            Select selectStatement = (Select)statement;
            LFConsistentHashingRoutingSqlInterceptor.processWhereClause((Statement)selectStatement, columnNames);
        } else if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            LFConsistentHashingRoutingSqlInterceptor.processWhereClause((Statement)updateStatement, columnNames);
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            LFConsistentHashingRoutingSqlInterceptor.processWhereClause((Statement)deleteStatement, columnNames);
        }
        return columnNames;
    }

    private static void processWhereClause(Statement statement, List<String> columnNames) {
        Expression whereClause = null;
        if (statement instanceof Select) {
            Select selectStatement = (Select)statement;
            PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
            whereClause = plainSelect.getWhere();
        } else if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            whereClause = updateStatement.getWhere();
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            whereClause = deleteStatement.getWhere();
        }
        if (whereClause != null) {
            columnNames.addAll(LFConsistentHashingRoutingSqlInterceptor.getColumnNames(whereClause));
        }
    }

    public static List<String> getColumnNames(Expression expression) {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (expression instanceof Column) {
            columnNames.add(((Column)expression).getColumnName());
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            columnNames.addAll(LFConsistentHashingRoutingSqlInterceptor.getColumnNames(binaryExpression.getLeftExpression()));
            columnNames.addAll(LFConsistentHashingRoutingSqlInterceptor.getColumnNames(binaryExpression.getRightExpression()));
        } else if (expression instanceof Parenthesis) {
            Parenthesis parenthesis = (Parenthesis)expression;
            columnNames.addAll(LFConsistentHashingRoutingSqlInterceptor.getColumnNames(parenthesis.getExpression()));
        }
        return columnNames;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void afterPropertiesSet() throws Exception {
        this.mainTableHashing = new ConsistentHashingAlg("t_lf_main", this.mainTableCount);
        this.fieldTableHashing = new ConsistentHashingAlg("t_lf_main_field", this.fieldTableCount);
    }
}

