/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.factory;

import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.openoa.engine.factory.SpfService;
import org.openoa.engine.factory.TagParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AdaptorFactoryAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AdaptorFactoryAspect.class);
    private ApplicationContext applicationContext;

    @Around(value="@annotation(org.openoa.engine.factory.SpfService)")
    public Object getBeanObject(ProceedingJoinPoint pj) throws Throwable {
        Signature signature = pj.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        Class<?> returnType = method.getReturnType();
        SpfService annotation = method.getAnnotation(SpfService.class);
        Class<TagParser<?, ?>> tagParserCls = annotation.tagParser();
        TagParser<?, ?> tagParser = tagParserCls.newInstance();
        Object param = tagParser.parseTag(pj.getArgs()[0]);
        if (!(param instanceof String)) {
            return param;
        }
        Map beansOfType = this.applicationContext.getBeansOfType(returnType);
        Object bean = beansOfType.get(param);
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

