/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.factory;

import org.apache.ibatis.javassist.ClassClassPath;
import org.apache.ibatis.javassist.ClassPath;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.CtMethod;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.anno.AutoParse;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.engine.factory.AutoParseProxyFactory;
import org.openoa.engine.factory.SpfService;
import org.openoa.engine.factory.TagParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptorFactoryProxy {
    private static final Logger log = LoggerFactory.getLogger(AdaptorFactoryProxy.class);
    private static final String SIMPLECLSNAME = "IAdaptorFactory";
    private static final String PACKAGENAME = "org.openoa.engine.factory";
    private static final String PROXYFREFIX = "$Proxy";
    private static final String PROXYSUFFIX = "Impl";
    private static volatile Object loadedInstance = null;

    private AdaptorFactoryProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getProxyInstance() {
        if (loadedInstance != null) return loadedInstance;
        String string = SIMPLECLSNAME;
        synchronized (SIMPLECLSNAME) {
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return AdaptorFactoryProxy.getProxyObj();
            }
            catch (Exception e) {
                e.printStackTrace();
                // ** MonitorExit[var0] (shouldn't be in output)
                return loadedInstance;
            }
        }
    }

    private static Object getProxyObj() throws Exception {
        if (loadedInstance != null) {
            return loadedInstance;
        }
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(AdaptorFactoryProxy.class));
        String proxyClsName = "org.openoa.engine.factory." + AdaptorFactoryProxy.getProxyObjectName();
        String sourceClsName = "org.openoa.engine.factory.IAdaptorFactory";
        CtClass targetClass = pool.makeClass(proxyClsName);
        CtClass interf = pool.getCtClass(sourceClsName);
        CtClass[] interfs = new CtClass[]{interf};
        targetClass.setInterfaces(interfs);
        for (CtMethod declaredMethod : interf.getDeclaredMethods()) {
            CtClass declaredMethodReturnType = declaredMethod.getReturnType();
            CtClass[] declaredMethodParameterTypes = declaredMethod.getParameterTypes();
            String declaredMethodName = declaredMethod.getName();
            CtMethod newMethod = new CtMethod(declaredMethodReturnType, declaredMethodName, declaredMethodParameterTypes, targetClass);
            SpfService annotation = (SpfService)declaredMethod.getAnnotation(SpfService.class);
            Class<TagParser<Object, Object>> tagParserCls = null;
            if (annotation != null) {
                tagParserCls = annotation.tagParser();
            } else {
                AutoParse autoParse = (AutoParse)declaredMethod.getAnnotation(AutoParse.class);
                if (autoParse == null) {
                    throw new AFBizException("adaptor method has neither tagparser nor AutoParse Annotation");
                }
                String paramTypeName = declaredMethodParameterTypes[0].getName();
                String returnTypeName = declaredMethodReturnType.getName();
                TagParser proxyInstance = AutoParseProxyFactory.getProxyInstance(TagParser.class, paramTypeName, returnTypeName);
                tagParserCls = proxyInstance.getClass();
            }
            String tagParserClassName = tagParserCls.getName();
            TagParser<?, ?> tagParser = tagParserCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SpringBeanUtils.putObject((String)tagParserClassName, tagParser);
            String declaredMethodReturnTypeName = declaredMethodReturnType.getName();
            String methodBody = "     {\n org.openoa.engine.factory.TagParser parser = (org.openoa.engine.factory.TagParser)org.openoa.base.util.SpringBeanUtils.getObject(\"" + tagParserClassName + "\");\n        Object beanOrName = parser.parseTag($1);\n if (!(beanOrName instanceof String)) {\nreturn (" + declaredMethodReturnTypeName + ")beanOrName;        } else { java.util.Map/*<String, ?>*/ beansOfType = org.openoa.base.util.SpringBeanUtils.getBeansOfType(" + declaredMethodReturnTypeName + ".class);\n Object bean = beansOfType.get((String)beanOrName);     return (" + declaredMethodReturnTypeName + ") bean;}}";
            newMethod.setBody(methodBody);
            newMethod.setModifiers(1);
            targetClass.addMethod(newMethod);
        }
        Class target = targetClass.toClass();
        Object newInstance = target.newInstance();
        targetClass.detach();
        loadedInstance = newInstance;
        return newInstance;
    }

    private static String getProxyObjectName() {
        return "$ProxyIAdaptorFactoryImpl";
    }
}

