/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.javassist.ClassClassPath;
import org.apache.ibatis.javassist.ClassPath;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.CtConstructor;
import org.apache.ibatis.javassist.CtMethod;
import org.apache.ibatis.javassist.bytecode.ClassFile;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.apache.ibatis.javassist.bytecode.SignatureAttribute;
import org.openoa.engine.factory.TagParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoParseProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(AutoParseProxyFactory.class);
    private static final String PROXYFREFIX = "$Proxy";
    private static final String PROXYSUFFIX = "Impl";
    private static Map<String, Object> loadedInstances = new HashMap<String, Object>();

    private AutoParseProxyFactory() {
    }

    public static synchronized <T> T getProxyInstance(Class<T> objToProxy, String paramTypeName, String returnTypeName) {
        String[] split = paramTypeName.split("\\.");
        String paramNameShortName = split[split.length - 1];
        String simpleName = paramNameShortName + objToProxy.getSimpleName();
        if (loadedInstances.get(simpleName) == null) {
            try {
                return (T)AutoParseProxyFactory.getProxyObj(simpleName, objToProxy, paramTypeName, returnTypeName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)loadedInstances.get(simpleName);
    }

    private static Object getProxyObj(String objName, Class<?> objToProxy, String paramTypeName, String returnTypeName) throws Exception {
        if (loadedInstances.get(objName) != null) {
            return loadedInstances.get(objName);
        }
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(objToProxy));
        String packageName = objToProxy.getPackage().getName();
        String proxyClsName = packageName + "." + AutoParseProxyFactory.getProxyObjectName(objName);
        String sourceClsName = packageName + "." + objToProxy.getSimpleName();
        CtClass targetClass = pool.makeClass(proxyClsName);
        ClassFile classFile = targetClass.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        CtConstructor constructor = new CtConstructor(new CtClass[0], targetClass);
        constructor.setModifiers(1);
        constructor.setBody("{}");
        targetClass.addConstructor(constructor);
        CtClass tagParserInterface = pool.get(TagParser.class.getName());
        targetClass.addInterface(tagParserInterface);
        String genericSignature = "L" + TagParser.class.getName().replace('.', '/') + "<L" + paramTypeName.replace('.', '/') + ";L" + returnTypeName + ";>;";
        targetClass.setGenericSignature(new SignatureAttribute.TypeVariable(genericSignature).encode());
        for (CtMethod declaredMethod : tagParserInterface.getDeclaredMethods()) {
            CtClass declaredMethodReturnType = declaredMethod.getReturnType();
            CtClass[] declaredMethodParameterTypes = declaredMethod.getParameterTypes();
            String declaredMethodName = declaredMethod.getName();
            CtMethod newMethod = new CtMethod(declaredMethodReturnType, declaredMethodName, declaredMethodParameterTypes, targetClass);
            String body = "{\n    if ($1 == null) {\n        throw new org.openoa.base.exception.AFBizException(\"provided data to find an adaptor method is null\");\n    }\n    java.util.Collection beans = org.openoa.base.util.SpringBeanUtils.getBeans(" + returnTypeName + ".class);\n    java.util.Iterator iterator = beans.iterator();\n    while (iterator.hasNext()) {\n        Object obj = iterator.next();\n        if (obj instanceof org.openoa.base.interf.AdaptorService) {\n            org.openoa.base.interf.AdaptorService bean = (org.openoa.base.interf.AdaptorService) obj;\n            if (bean.isSupportBusinessObject((Enum) $1)) {\n                return (" + returnTypeName + ") bean;\n            }\n        }\n    }\n    System.out.println(\"nothing is return,for debugging use only\");\n    return null;\n}";
            newMethod.setBody(body);
            newMethod.setModifiers(1);
            targetClass.addMethod(newMethod);
        }
        Class target = targetClass.toClass();
        Object newInstance = target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        targetClass.detach();
        loadedInstances.put(objName, newInstance);
        return newInstance;
    }

    private static String getProxyObjectName(String objName) {
        return "$Proxy_" + objName + PROXYSUFFIX;
    }
}

