/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.factory;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.openoa.base.entity.OutSideBpmAccessBusiness;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmAccessBusinessServiceImpl;
import org.openoa.engine.factory.IAdaptorFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class FormFactory
implements ApplicationContextAware {
    @Autowired
    private IAdaptorFactory adaptorFactory;
    @Autowired
    @Lazy
    private OutSideBpmAccessBusinessServiceImpl outSideBpmAccessBusinessService;
    private ApplicationContext applicationContext;

    public FormOperationAdaptor getFormAdaptor(String formCode) {
        return this.getFormAdaptor(BusinessDataVo.builder().formCode(formCode).build());
    }

    public FormOperationAdaptor getFormAdaptor(BusinessDataVo vo) {
        if (ObjectUtils.isEmpty((Object)vo)) {
            return null;
        }
        FormOperationAdaptor activitiService = this.adaptorFactory.getActivitiService(vo);
        if (ObjectUtils.isEmpty((Object)activitiService)) {
            throw new AFBizException("form code does not have a processing bean\uff01");
        }
        return activitiService;
    }

    public BusinessDataVo dataFormConversion(String params, String formCode) {
        Object bean;
        LambdaQueryWrapper qryWrapper;
        List bpmAccessBusinesses;
        BusinessDataVo vo = (BusinessDataVo)JSON.parseObject((String)params, BusinessDataVo.class);
        if (formCode == null) {
            formCode = vo.getFormCode();
        }
        if (vo.getIsOutSideAccessProc().booleanValue() && !CollectionUtils.isEmpty((Collection)(bpmAccessBusinesses = this.outSideBpmAccessBusinessService.list((Wrapper)(qryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutSideBpmAccessBusiness::getProcessNumber, (Object)vo.getProcessNumber())))))) {
            vo.setFormData(((OutSideBpmAccessBusiness)bpmAccessBusinesses.get(0)).getFormDataPc());
        }
        if (vo.getIsLowCodeFlow() != null && vo.getIsLowCodeFlow() == 1) {
            formCode = "LF";
        }
        if (ObjectUtils.isEmpty((Object)(bean = this.applicationContext.getBean(formCode)))) {
            throw new AFBizException("can not get the processing bean by form code:{}!" + formCode);
        }
        return (BusinessDataVo)JSON.parseObject((String)params, this.getFormTClass(formCode));
    }

    private Class<?> getFormTClass(String key) {
        Type[] interfacesTypes;
        ParameterizedType p;
        Class cls;
        FormOperationAdaptor bean = this.getFormAdaptor(BusinessDataVo.builder().formCode(key).build());
        if (!ObjectUtils.isEmpty((Object)bean) && !ObjectUtils.isEmpty((Object)(cls = (Class)(p = (ParameterizedType)(interfacesTypes = ClassUtils.getUserClass((Object)bean).getGenericInterfaces())[0]).getActualTypeArguments()[0]))) {
            return cls;
        }
        throw new AFBizException("\u8be5\u8868\u5355\u672a\u5173\u8054\u4e1a\u52a1\u5b9e\u73b0\u7c7b\u6216\u672a\u5173\u8054\u5b9e\u73b0\u7c7b\u6cdb\u578b\uff01");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

