/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.javassist.ClassClassPath;
import org.apache.ibatis.javassist.ClassPath;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.CtConstructor;
import org.apache.ibatis.javassist.CtMethod;
import org.apache.ibatis.javassist.bytecode.AnnotationsAttribute;
import org.apache.ibatis.javassist.bytecode.AttributeInfo;
import org.apache.ibatis.javassist.bytecode.ClassFile;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleProxyFactory.class);
    private static final String PROXYFREFIX = "$Proxy";
    private static final String PROXYSUFFIX = "Impl";
    private static Map<String, Object> loadedInstances = new HashMap<String, Object>();

    private SimpleProxyFactory() {
    }

    public static synchronized <T> T getProxyInstance(Class<T> objToProxy) {
        String simpleName = objToProxy.getSimpleName();
        if (loadedInstances.get(simpleName) == null) {
            try {
                return (T)SimpleProxyFactory.getProxyObj(simpleName, objToProxy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)loadedInstances.get(simpleName);
    }

    private static Object getProxyObj(String objName, Class<?> objToProxy) throws Exception {
        if (loadedInstances.get(objName) != null) {
            return loadedInstances.get(objName);
        }
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath((ClassPath)new ClassClassPath(objToProxy));
        String packageName = objToProxy.getPackage().getName();
        String proxyClsName = packageName + "." + SimpleProxyFactory.getProxyObjectName(objName);
        String sourceClsName = packageName + "." + objToProxy.getSimpleName();
        CtClass targetClass = pool.makeClass(proxyClsName);
        ClassFile classFile = targetClass.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        CtConstructor constructor = new CtConstructor(new CtClass[0], targetClass);
        constructor.setModifiers(1);
        constructor.setBody("{}");
        targetClass.addConstructor(constructor);
        CtClass interf = pool.getCtClass(sourceClsName);
        CtClass[] interfs = new CtClass[]{interf};
        targetClass.setInterfaces(interfs);
        for (CtMethod declaredMethod : interf.getDeclaredMethods()) {
            CtClass declaredMethodReturnType = declaredMethod.getReturnType();
            CtClass[] declaredMethodParameterTypes = declaredMethod.getParameterTypes();
            String declaredMethodName = declaredMethod.getName();
            CtMethod newMethod = new CtMethod(declaredMethodReturnType, declaredMethodName, declaredMethodParameterTypes, targetClass);
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            newMethod.getMethodInfo().addAttribute((AttributeInfo)attr);
            String methodBody = " {\n System.out.println(\"Hello,you called a dynamically generated method,this message is for debugging use only\");\nreturn null;    }";
            newMethod.setBody(methodBody);
            newMethod.setModifiers(1);
            targetClass.addMethod(newMethod);
        }
        Class target = targetClass.toClass();
        Object newInstance = target.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        targetClass.detach();
        loadedInstances.put(objName, newInstance);
        return newInstance;
    }

    private static String getProxyObjectName(String objName) {
        return "$Proxy_" + objName + PROXYSUFFIX;
    }
}

