/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.factory;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.openoa.base.constant.enums.CallbackTypeEnum;
import org.openoa.base.entity.OutSideBpmCallbackUrlConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmVerifyInfoVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.engine.bpmnconf.service.biz.BpmVerifyInfoBizServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmCallbackUrlConfServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.OutSideBpmBusinessPartyBizService;
import org.openoa.engine.factory.CallbackAdaptor;
import org.openoa.engine.utils.JsonUtils;
import org.openoa.engine.vo.CallbackReqVo;
import org.openoa.engine.vo.CallbackRespVo;
import org.openoa.engine.vo.OutSideBpmAccessProcessRecordVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ThirdPartyCallbackFactory {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyCallbackFactory.class);
    private static volatile ThirdPartyCallbackFactory thirdPartyCallbackFactory;
    private static final ThreadLocalRandom random;

    private ThirdPartyCallbackFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThirdPartyCallbackFactory build() {
        if (thirdPartyCallbackFactory != null) return thirdPartyCallbackFactory;
        Class<ThirdPartyCallbackFactory> clazz = ThirdPartyCallbackFactory.class;
        synchronized (ThirdPartyCallbackFactory.class) {
            if (thirdPartyCallbackFactory != null) return thirdPartyCallbackFactory;
            thirdPartyCallbackFactory = new ThirdPartyCallbackFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return thirdPartyCallbackFactory;
        }
    }

    public <T> T doCallback(CallbackTypeEnum callbackTypeEnum, BpmnConfVo bpmnConfVo, String processNum, String businessId) {
        block16: {
            boolean callBackSwitch = true;
            Environment environment = (Environment)SpringBeanUtils.getBean(Environment.class);
            String callbackSwitchStr = environment.getProperty("outside.callback.switch");
            if (!StringUtils.isEmpty((CharSequence)callbackSwitchStr)) {
                callBackSwitch = Boolean.parseBoolean(callbackSwitchStr);
            }
            CallbackReqVo callbackReqVo = null;
            String resultJson = "";
            HashMap heads = Maps.newHashMap();
            try {
                if (ObjectUtils.isEmpty((Object)bpmnConfVo.getBusinessPartyId())) {
                    throw new AFBizException("\u4e1a\u52a1\u65b9\u7f3a\u5931\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
                }
                CallbackAdaptor callbackAdaptor = this.getCallbackAdaptor(callbackTypeEnum.getBeanId());
                if (callbackAdaptor == null) {
                    return null;
                }
                if (!callBackSwitch) {
                    Object newRespObj = callbackAdaptor.getNewRespObj();
                    if (!StringUtils.isEmpty((CharSequence)businessId)) {
                        Integer rendomNum = Math.abs(random.nextInt(Integer.MAX_VALUE));
                        ((CallbackRespVo)newRespObj).setBusinessId(String.valueOf(rendomNum));
                    }
                    return (T)newRespObj;
                }
                callbackReqVo = (CallbackReqVo)callbackAdaptor.formatRequest(bpmnConfVo);
                callbackReqVo.setEventType(callbackTypeEnum.getMark());
                OutSideBpmBusinessPartyBizService bean = (OutSideBpmBusinessPartyBizService)SpringBeanUtils.getBean(OutSideBpmBusinessPartyBizService.class);
                String businessPartyMarkById = bean.getBusinessPartyMarkById(bpmnConfVo.getBusinessPartyId());
                callbackReqVo.setBusinessPartyMark(businessPartyMarkById);
                callbackReqVo.setFormCode(this.formatFormCode(businessPartyMarkById, bpmnConfVo.getFormCode()));
                callbackReqVo.setProcessNum(processNum);
                if (!StringUtils.isEmpty((CharSequence)processNum)) {
                    BpmVerifyInfoBizServiceImpl bpmVerifyInfoNewService = (BpmVerifyInfoBizServiceImpl)SpringBeanUtils.getBean(BpmVerifyInfoBizServiceImpl.class);
                    boolean finishFlag = callbackTypeEnum.equals((Object)CallbackTypeEnum.PROC_FINISH_CALL_BACK);
                    List<BpmVerifyInfoVo> bpmVerifyInfoVos = bpmVerifyInfoNewService.getBpmVerifyInfoVos(processNum, finishFlag);
                    callbackReqVo.setProcessRecord(bpmVerifyInfoVos.stream().map(o -> OutSideBpmAccessProcessRecordVo.builder().nodeName(o.getTaskName()).approvalTime(Optional.ofNullable(o.getVerifyDate()).map(od -> DateUtil.SDF_DATETIME_PATTERN.format(od)).orElse("")).approvalStatusName(o.getVerifyStatusName()).approvalUserName(o.getVerifyUserName()).build()).collect(Collectors.toList()));
                }
                callbackReqVo.setBusinessId(businessId);
                BaseIdTranStruVo loginedEmployee = SecurityUtils.getLogInEmpInfo();
                if (ObjectUtils.isEmpty((Object)loginedEmployee)) {
                    loginedEmployee = new BaseIdTranStruVo();
                }
                OutSideBpmCallbackUrlConfServiceImpl outSideBpmCallbackUrlConfService = (OutSideBpmCallbackUrlConfServiceImpl)SpringBeanUtils.getBean(OutSideBpmCallbackUrlConfServiceImpl.class);
                OutSideBpmCallbackUrlConf outSideBpmCallbackUrlConf = outSideBpmCallbackUrlConfService.getOutSideBpmCallbackUrlConf(bpmnConfVo.getId(), bpmnConfVo.getBusinessPartyId());
                String url = "";
                heads.put("central-service", this.getCurrentSysDomain());
                if (outSideBpmCallbackUrlConf != null) {
                    url = outSideBpmCallbackUrlConf.getBpmFlowCallbackUrl();
                    String apiClientId = outSideBpmCallbackUrlConf.getApiClientId();
                    String apiClientSecret = outSideBpmCallbackUrlConf.getApiClientSecret();
                    heads.put("api-client-id", apiClientId);
                    String jsonString = JSON.toJSONString((Object)callbackReqVo);
                    String md5Hex = DigestUtils.md5Hex((String)(jsonString + apiClientSecret));
                    String sign = Base64.encodeBase64String((byte[])md5Hex.getBytes(StandardCharsets.UTF_8));
                    heads.put("api-workflow-sign", sign);
                }
                heads.put("sso-uid", loginedEmployee.getId());
                heads.put("sso-name", URLEncoder.encode(loginedEmployee.getName(), "UTF-8"));
                log.info("\u6267\u884c\u5916\u90e8\u5de5\u4f5c\u6d41\u56de\u8c03,request\uff1a{} , processNumber:{} , callBackUrl:{} , \u64cd\u4f5c\u4eba\uff1a{} ,\u8bf7\u6c42\u53c2\u6570:{}", new Object[]{callbackTypeEnum.getDesc(), processNum, url, loginedEmployee.getName(), JsonUtils.transfer2JsonString(callbackReqVo)});
                resultJson = this.doPost(url, heads, callbackReqVo);
                log.info("\u6267\u884c\u5916\u90e8\u5de5\u4f5c\u6d41\u56de\u8c03,response\uff1a{} , processNumber:{} , callBackUrl:{} , \u64cd\u4f5c\u4eba\uff1a{} ,\u8bf7\u6c42\u53c2\u6570:{} , response:{}", new Object[]{callbackTypeEnum.getDesc(), processNum, url, loginedEmployee.getName(), JsonUtils.transfer2JsonString(callbackReqVo), resultJson});
                if (StringUtils.isEmpty((CharSequence)resultJson)) {
                    return null;
                }
                JSONObject resultObject = JSON.parseObject((String)resultJson);
                Object status = resultObject.get("status");
                String successMark = "000000";
                if (!ObjectUtils.isEmpty((Object)status) && successMark.equals(status.toString())) {
                    Object callbackRespVo = callbackAdaptor.formatResponce(resultJson);
                    if (callbackRespVo != null) {
                        ((CallbackRespVo)callbackRespVo).setBusinessPartyMark(businessPartyMarkById);
                        return (T)callbackRespVo;
                    }
                    break block16;
                }
                Object message = resultObject.get("message");
                String messageStr = "";
                if (!ObjectUtils.isEmpty((Object)message)) {
                    messageStr = message.toString();
                }
                if (!StringUtils.isEmpty((CharSequence)messageStr)) {
                    throw new AFBizException(messageStr);
                }
                throw new AFBizException("\u5de5\u4f5c\u6d41\u5bf9\u5916\u670d\u52a1\u56de\u8c03\u5931\u8d25");
            }
            catch (AFBizException e) {
                log.error("\u5de5\u4f5c\u6d41\u5bf9\u5916\u670d\u52a1\u56de\u8c03\u5931\u8d25\uff0c\u56de\u8c03\u7c7b\u578b\uff1a{}\uff0c\u8bf7\u6c42\u5934\u4fe1\u606f{}\uff0c\u5165\u53c2\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", new Object[]{callbackTypeEnum.getMark(), JSON.toJSONString((Object)heads), JSON.toJSONString(Optional.ofNullable(callbackReqVo).orElse(new CallbackReqVo())), resultJson, e});
                return null;
            }
            catch (Exception e) {
                log.error("\u5de5\u4f5c\u6d41\u5bf9\u5916\u670d\u52a1\u56de\u8c03\u5931\u8d25\uff0c\u56de\u8c03\u7c7b\u578b\uff1a{}\uff0c\u8bf7\u6c42\u5934\u4fe1\u606f{}\uff0c\u5165\u53c2\uff1a{}\uff0c\u51fa\u53c2\uff1a{}", new Object[]{callbackTypeEnum.getMark(), JSON.toJSONString((Object)heads), JSON.toJSONString(Optional.ofNullable(callbackReqVo).orElse(new CallbackReqVo())), resultJson, e});
                return null;
            }
        }
        return null;
    }

    public String formatFormCode(String businessPartyMarkById, String formCode) {
        if (formCode.startsWith(businessPartyMarkById)) {
            return formCode;
        }
        return StringUtils.join((Object[])new String[]{businessPartyMarkById, "_", formCode});
    }

    private CallbackAdaptor getCallbackAdaptor(String eventType) {
        return (CallbackAdaptor)SpringBeanUtils.getBean((String)eventType, CallbackAdaptor.class);
    }

    private String getCurrentSysDomain() {
        HttpServletRequest request = this.getHttpServletRequest();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        return basePath;
    }

    private HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes.getRequest();
    }

    private String doPost(String url, Map<String, String> heads, Object object) throws Exception {
        String resultStr;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            if (!CollectionUtils.isEmpty(heads)) {
                heads.forEach((key, val) -> httpPost.addHeader(key, val));
            }
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            String input = object instanceof String ? (String)object : JSON.toJSONString((Object)object);
            StringEntity stringEntity = new StringEntity(input, "UTF-8");
            stringEntity.setContentType("application/json;charset=UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            log.error("\u5de5\u4f5c\u6d41\u5bf9\u5916\u670d\u52a1\u56de\u8c03POST\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
            throw new Exception(e);
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        return resultStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThirdPartyCallbackFactory)) {
            return false;
        }
        ThirdPartyCallbackFactory other = (ThirdPartyCallbackFactory)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThirdPartyCallbackFactory;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ThirdPartyCallbackFactory()";
    }

    static {
        random = ThreadLocalRandom.current();
    }
}

