/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.lowflow.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.LFControlTypeEnum;
import org.openoa.base.constant.enums.LFFieldTypeEnum;
import org.openoa.base.entity.BpmnConfLfFormdataField;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.TenantField;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.SnowFlake;
import org.springframework.util.CollectionUtils;

@TableName(value="t_lf_main_field")
public class LFMainField
implements TenantField,
Serializable {
    @TableId(value="id", type=IdType.ASSIGN_ID)
    private Long id;
    @TableField(value="main_id")
    private Long mainId;
    @TableField(value="form_code")
    private String formCode;
    @TableField(value="field_id")
    private String fieldId;
    @TableField(value="field_name")
    private String fieldName;
    @TableField(value="parent_field_id")
    private String parentFieldId;
    @TableField(value="parent_field_name")
    private String parentFieldName;
    @TableField(value="field_value")
    private String fieldValue;
    @TableField(value="field_value_number")
    private Double fieldValueNumber;
    @TableField(value="field_value_dt")
    private Date fieldValueDt;
    @TableField(value=" field_value_text")
    private String fieldValueText;
    private Integer sort = 0;
    @TableLogic
    @TableField(value="is_del")
    private Integer isDel;
    @TableField(value="tenant_id")
    private String tenantId;
    @TableField(value="create_user")
    private String createUser;
    @TableField(value="create_time", fill=FieldFill.INSERT)
    private Date createTime;
    @TableField(value="update_user")
    private String updateUser;
    @TableField(value="update_time", fill=FieldFill.INSERT_UPDATE)
    private Date updateTime;

    public static List<LFMainField> parseFromMap(Map<String, Object> fieldMap, Map<String, BpmnConfLfFormdataField> fieldConfigMap, Long mainId, String formCode) {
        if (CollectionUtils.isEmpty(fieldMap)) {
            throw new AFBizException("form data has no value");
        }
        if (CollectionUtils.isEmpty(fieldConfigMap)) {
            throw new AFBizException("field configs are empty,please check your logic");
        }
        ArrayList<LFMainField> mainFields = new ArrayList<LFMainField>(fieldMap.size());
        for (Map.Entry<String, Object> fieldId2ValueEntry : fieldMap.entrySet()) {
            String fieldId = fieldId2ValueEntry.getKey();
            BpmnConfLfFormdataField fieldConfig = fieldConfigMap.get(fieldId);
            if (fieldConfig == null) continue;
            Object value = fieldId2ValueEntry.getValue();
            LFMainField mainField = LFMainField.buildMainField(value, mainId, 0, fieldConfig);
            mainField.setFormCode(formCode);
            mainFields.add(mainField);
        }
        return mainFields;
    }

    public static LFMainField buildMainField(Object fieldValue, Long mainId, int sort, BpmnConfLfFormdataField fieldConfig) {
        String fieldValueStr = null;
        if (fieldValue != null) {
            fieldValueStr = fieldValue.toString();
        }
        LFMainField mainField = new LFMainField();
        mainField.setId(SnowFlake.nextId());
        mainField.setMainId(mainId);
        mainField.setFieldId(fieldConfig.getFieldId());
        mainField.setFieldName(fieldConfig.getFieldName());
        Integer fieldType = fieldConfig.getFieldType();
        LFFieldTypeEnum fieldTypeEnum = LFFieldTypeEnum.getByType((Integer)fieldType);
        if (fieldTypeEnum == null) {
            throw new AFBizException(Strings.lenientFormat((String)"field type can not be empty,%s", (Object[])new Object[]{fieldConfig}));
        }
        switch (fieldTypeEnum) {
            case STRING: {
                mainField.setFieldValue(fieldValueStr);
                break;
            }
            case NUMBER: {
                if (LFControlTypeEnum.SELECT.getName().equals(fieldConfig.getFieldName())) {
                    mainField.setFieldValue(fieldValueStr);
                    break;
                }
                Double fieldValueNumber = !StringUtils.isEmpty((CharSequence)fieldValueStr) ? Double.valueOf(Double.parseDouble(fieldValueStr)) : null;
                mainField.setFieldValueNumber(fieldValueNumber);
                break;
            }
            case DATE: 
            case DATE_TIME: {
                Date fieldValueDt = !StringUtils.isEmpty((CharSequence)fieldValueStr) ? DateUtil.parseStandard((String)fieldValueStr) : null;
                mainField.setFieldValueDt(fieldValueDt);
                break;
            }
            case TEXT: {
                mainField.setFieldValueText(fieldValueStr);
                break;
            }
            case BOOLEAN: {
                mainField.setFieldValue(String.valueOf(fieldValueStr));
            }
        }
        mainField.setSort(sort);
        return mainField;
    }

    public Long getId() {
        return this.id;
    }

    public Long getMainId() {
        return this.mainId;
    }

    public String getFormCode() {
        return this.formCode;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getParentFieldId() {
        return this.parentFieldId;
    }

    public String getParentFieldName() {
        return this.parentFieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public Double getFieldValueNumber() {
        return this.fieldValueNumber;
    }

    public Date getFieldValueDt() {
        return this.fieldValueDt;
    }

    public String getFieldValueText() {
        return this.fieldValueText;
    }

    public Integer getSort() {
        return this.sort;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMainId(Long mainId) {
        this.mainId = mainId;
    }

    public void setFormCode(String formCode) {
        this.formCode = formCode;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setParentFieldId(String parentFieldId) {
        this.parentFieldId = parentFieldId;
    }

    public void setParentFieldName(String parentFieldName) {
        this.parentFieldName = parentFieldName;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public void setFieldValueNumber(Double fieldValueNumber) {
        this.fieldValueNumber = fieldValueNumber;
    }

    public void setFieldValueDt(Date fieldValueDt) {
        this.fieldValueDt = fieldValueDt;
    }

    public void setFieldValueText(String fieldValueText) {
        this.fieldValueText = fieldValueText;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LFMainField)) {
            return false;
        }
        LFMainField other = (LFMainField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$mainId = this.getMainId();
        Long other$mainId = other.getMainId();
        if (this$mainId == null ? other$mainId != null : !((Object)this$mainId).equals(other$mainId)) {
            return false;
        }
        Double this$fieldValueNumber = this.getFieldValueNumber();
        Double other$fieldValueNumber = other.getFieldValueNumber();
        if (this$fieldValueNumber == null ? other$fieldValueNumber != null : !((Object)this$fieldValueNumber).equals(other$fieldValueNumber)) {
            return false;
        }
        Integer this$sort = this.getSort();
        Integer other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        Integer this$isDel = this.getIsDel();
        Integer other$isDel = other.getIsDel();
        if (this$isDel == null ? other$isDel != null : !((Object)this$isDel).equals(other$isDel)) {
            return false;
        }
        String this$formCode = this.getFormCode();
        String other$formCode = other.getFormCode();
        if (this$formCode == null ? other$formCode != null : !this$formCode.equals(other$formCode)) {
            return false;
        }
        String this$fieldId = this.getFieldId();
        String other$fieldId = other.getFieldId();
        if (this$fieldId == null ? other$fieldId != null : !this$fieldId.equals(other$fieldId)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$parentFieldId = this.getParentFieldId();
        String other$parentFieldId = other.getParentFieldId();
        if (this$parentFieldId == null ? other$parentFieldId != null : !this$parentFieldId.equals(other$parentFieldId)) {
            return false;
        }
        String this$parentFieldName = this.getParentFieldName();
        String other$parentFieldName = other.getParentFieldName();
        if (this$parentFieldName == null ? other$parentFieldName != null : !this$parentFieldName.equals(other$parentFieldName)) {
            return false;
        }
        String this$fieldValue = this.getFieldValue();
        String other$fieldValue = other.getFieldValue();
        if (this$fieldValue == null ? other$fieldValue != null : !this$fieldValue.equals(other$fieldValue)) {
            return false;
        }
        Date this$fieldValueDt = this.getFieldValueDt();
        Date other$fieldValueDt = other.getFieldValueDt();
        if (this$fieldValueDt == null ? other$fieldValueDt != null : !((Object)this$fieldValueDt).equals(other$fieldValueDt)) {
            return false;
        }
        String this$fieldValueText = this.getFieldValueText();
        String other$fieldValueText = other.getFieldValueText();
        if (this$fieldValueText == null ? other$fieldValueText != null : !this$fieldValueText.equals(other$fieldValueText)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$createUser = this.getCreateUser();
        String other$createUser = other.getCreateUser();
        if (this$createUser == null ? other$createUser != null : !this$createUser.equals(other$createUser)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$updateUser = this.getUpdateUser();
        String other$updateUser = other.getUpdateUser();
        if (this$updateUser == null ? other$updateUser != null : !this$updateUser.equals(other$updateUser)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LFMainField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $mainId = this.getMainId();
        result = result * 59 + ($mainId == null ? 43 : ((Object)$mainId).hashCode());
        Double $fieldValueNumber = this.getFieldValueNumber();
        result = result * 59 + ($fieldValueNumber == null ? 43 : ((Object)$fieldValueNumber).hashCode());
        Integer $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        Integer $isDel = this.getIsDel();
        result = result * 59 + ($isDel == null ? 43 : ((Object)$isDel).hashCode());
        String $formCode = this.getFormCode();
        result = result * 59 + ($formCode == null ? 43 : $formCode.hashCode());
        String $fieldId = this.getFieldId();
        result = result * 59 + ($fieldId == null ? 43 : $fieldId.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $parentFieldId = this.getParentFieldId();
        result = result * 59 + ($parentFieldId == null ? 43 : $parentFieldId.hashCode());
        String $parentFieldName = this.getParentFieldName();
        result = result * 59 + ($parentFieldName == null ? 43 : $parentFieldName.hashCode());
        String $fieldValue = this.getFieldValue();
        result = result * 59 + ($fieldValue == null ? 43 : $fieldValue.hashCode());
        Date $fieldValueDt = this.getFieldValueDt();
        result = result * 59 + ($fieldValueDt == null ? 43 : ((Object)$fieldValueDt).hashCode());
        String $fieldValueText = this.getFieldValueText();
        result = result * 59 + ($fieldValueText == null ? 43 : $fieldValueText.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $createUser = this.getCreateUser();
        result = result * 59 + ($createUser == null ? 43 : $createUser.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $updateUser = this.getUpdateUser();
        result = result * 59 + ($updateUser == null ? 43 : $updateUser.hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "LFMainField(id=" + this.getId() + ", mainId=" + this.getMainId() + ", formCode=" + this.getFormCode() + ", fieldId=" + this.getFieldId() + ", fieldName=" + this.getFieldName() + ", parentFieldId=" + this.getParentFieldId() + ", parentFieldName=" + this.getParentFieldName() + ", fieldValue=" + this.getFieldValue() + ", fieldValueNumber=" + this.getFieldValueNumber() + ", fieldValueDt=" + this.getFieldValueDt() + ", fieldValueText=" + this.getFieldValueText() + ", sort=" + this.getSort() + ", isDel=" + this.getIsDel() + ", tenantId=" + this.getTenantId() + ", createUser=" + this.getCreateUser() + ", createTime=" + this.getCreateTime() + ", updateUser=" + this.getUpdateUser() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

