/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.lowflow.service;

import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.service.AntFlowOrderPostProcessor;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.activitilistener.WorkflowButtonHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AntFlowButtonsOperationPostProcessor
implements AntFlowOrderPostProcessor<BusinessDataVo> {
    @Autowired
    private WorkflowButtonHandler workflowButtonHandler;

    public void postProcess(BusinessDataVo vo) {
        ProcessOperationEnum poEnum = ProcessOperationEnum.getEnumByCode((Integer)vo.getOperationType());
        if (poEnum == null) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b: " + vo.getOperationType());
        }
        switch (poEnum) {
            case BUTTON_TYPE_SUBMIT: {
                this.workflowButtonHandler.onSubmit(vo);
                break;
            }
            case BUTTON_TYPE_RESUBMIT: {
                this.workflowButtonHandler.onResubmit(vo);
                break;
            }
            case BUTTON_TYPE_AGREE: {
                this.workflowButtonHandler.onAgree(vo);
                break;
            }
            case BUTTON_TYPE_DIS_AGREE: {
                this.workflowButtonHandler.onDisAgree(vo);
                break;
            }
            case BUTTON_TYPE_VIEW_BUSINESS_PROCESS: {
                this.workflowButtonHandler.onViewBusinessProcess(vo);
                break;
            }
            case BUTTON_TYPE_ABANDON: {
                this.workflowButtonHandler.onAbandon(vo);
                break;
            }
            case BUTTON_TYPE_UNDERTAKE: {
                this.workflowButtonHandler.onUndertake(vo);
                break;
            }
            case BUTTON_TYPE_CHANGE_ASSIGNEE: {
                this.workflowButtonHandler.onChangeAssignee(vo);
                break;
            }
            case BUTTON_TYPE_STOP: {
                this.workflowButtonHandler.onStop(vo);
                break;
            }
            case BUTTON_TYPE_FORWARD: {
                this.workflowButtonHandler.onForward(vo);
                break;
            }
            case BUTTON_TYPE_BACK_TO_MODIFY: {
                this.workflowButtonHandler.onBackToModify(vo);
                break;
            }
            case BUTTON_TYPE_JP: {
                this.workflowButtonHandler.onJp(vo);
                break;
            }
            case BUTTON_TYPE_ZB: {
                this.workflowButtonHandler.onZb(vo);
                break;
            }
            case BUTTON_TYPE_CHOOSE_ASSIGNEE: {
                this.workflowButtonHandler.onChooseAssignee(vo);
                break;
            }
            case BUTTON_TYPE_BACK_TO_ANY_NODE: {
                this.workflowButtonHandler.onBackToAnyNode(vo);
                break;
            }
            case BUTTON_TYPE_REMOVE_ASSIGNEE: {
                this.workflowButtonHandler.onRemoveAssignee(vo);
                break;
            }
            case BUTTON_TYPE_ADD_ASSIGNEE: {
                this.workflowButtonHandler.onAddAssignee(vo);
                break;
            }
            case BUTTON_TYPE_CHANGE_FUTURE_ASSIGNEE: {
                this.workflowButtonHandler.onChangeFutureAssignee(vo);
                break;
            }
            case BUTTON_TYPE_REMOVE_FUTURE_ASSIGNEE: {
                this.workflowButtonHandler.onRemoveFutureAssignee(vo);
                break;
            }
            case BUTTON_TYPE_ADD_FUTURE_ASSIGNEE: {
                this.workflowButtonHandler.onAddFutureAssignee(vo);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b: " + poEnum);
            }
        }
    }

    public int order() {
        return 0;
    }
}

