/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.lowflow.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openoa.base.entity.BpmnNodeLfFormdataFieldControl;
import org.openoa.base.service.AntFlowOrderPostProcessor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.LFFieldControlVO;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeLfFormdataFieldControlServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LFFieldControlPostProcessor
implements AntFlowOrderPostProcessor<BpmnConfVo> {
    @Autowired
    private BpmnNodeLfFormdataFieldControlServiceImpl lfFormdataFieldControlService;

    public int order() {
        return 0;
    }

    public void postProcess(BpmnConfVo confVo) {
        boolean lowCodeFlowFlag;
        if (confVo == null) {
            return;
        }
        Integer isLowCodeFlow = confVo.getIsLowCodeFlow();
        boolean bl = lowCodeFlowFlag = isLowCodeFlow != null && isLowCodeFlow == 1;
        if (!lowCodeFlowFlag) {
            return;
        }
        List bpmnNodeVos = confVo.getNodes();
        Long lfFormDataId = confVo.getLfFormDataId();
        ArrayList<BpmnNodeLfFormdataFieldControl> fieldControls = new ArrayList<BpmnNodeLfFormdataFieldControl>();
        for (BpmnNodeVo bpmnNodeVo : bpmnNodeVos) {
            List lfFieldControlVOs = bpmnNodeVo.getLfFieldControlVOs();
            if (CollectionUtils.isEmpty((Collection)lfFieldControlVOs)) continue;
            for (LFFieldControlVO lfFieldControlVO : lfFieldControlVOs) {
                BpmnNodeLfFormdataFieldControl fieldControl = new BpmnNodeLfFormdataFieldControl();
                fieldControl.setFormdataId(lfFormDataId);
                fieldControl.setNodeId(bpmnNodeVo.getId());
                fieldControl.setFieldId(lfFieldControlVO.getFieldId());
                fieldControl.setFieldName(lfFieldControlVO.getFieldName());
                fieldControl.setPerm(lfFieldControlVO.getPerm());
                fieldControl.setCreateUser(SecurityUtils.getLogInEmpName());
                fieldControls.add(fieldControl);
            }
        }
        this.lfFormdataFieldControlService.saveBatch(fieldControls);
    }
}

