/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.lowflow.service;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openoa.base.constant.enums.VariantFormContainerTypeEnum;
import org.openoa.base.entity.BpmnConfLfFormdata;
import org.openoa.base.entity.BpmnConfLfFormdataField;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AntFlowOrderPreProcessor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.FormConfigWrapper;
import org.openoa.engine.bpmnconf.service.BpmnConfLfFormdataFieldServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnConfLfFormdataServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LFFormDataPreProcessor
implements AntFlowOrderPreProcessor<BpmnConfVo> {
    @Autowired
    private BpmnConfLfFormdataServiceImpl lfFormdataService;
    @Autowired
    private BpmnConfLfFormdataFieldServiceImpl lfFormdataFieldService;

    public void preWriteProcess(BpmnConfVo confVo) {
        boolean lowCodeFlowFlag;
        if (confVo == null) {
            return;
        }
        Integer isLowCodeFlow = confVo.getIsLowCodeFlow();
        boolean bl = lowCodeFlowFlag = isLowCodeFlow != null && isLowCodeFlow == 1;
        if (!lowCodeFlowFlag) {
            return;
        }
        Long confId = confVo.getId();
        String lfForm = confVo.getLfFormData();
        BpmnConfLfFormdata lfFormdata = new BpmnConfLfFormdata();
        lfFormdata.setBpmnConfId(confId);
        lfFormdata.setFormdata(lfForm);
        lfFormdata.setCreateUser(SecurityUtils.getLogInEmpName());
        this.lfFormdataService.save(lfFormdata);
        confVo.setLfFormDataId(lfFormdata.getId());
        FormConfigWrapper formConfigWrapper = (FormConfigWrapper)JSON.parseObject((String)lfForm, FormConfigWrapper.class);
        List lfWidgetList = formConfigWrapper.getWidgetList();
        if (CollectionUtils.isEmpty((Collection)lfWidgetList)) {
            throw new AFBizException(Strings.lenientFormat((String)"lowcode form has no widget,confId:%d,formCode:%s", (Object[])new Object[]{confId, confVo.getFormCode()}));
        }
        ArrayList<BpmnConfLfFormdataField> formdataFields = new ArrayList<BpmnConfLfFormdataField>();
        this.parseWidgetListRecursively(lfWidgetList, confId, lfFormdata.getId(), formdataFields);
        if (CollectionUtils.isEmpty(formdataFields)) {
            throw new AFBizException(Strings.lenientFormat((String)"lowcode form fields can not be empty,confId:%d,formCode:%s", (Object[])new Object[]{confId, confVo.getFormCode()}));
        }
        this.lfFormdataFieldService.saveBatch(formdataFields);
    }

    public void preReadProcess(BpmnConfVo confVo) {
        boolean lowCodeFlowFlag;
        if (confVo == null) {
            return;
        }
        Integer isLowCodeFlow = confVo.getIsLowCodeFlow();
        boolean bl = lowCodeFlowFlag = isLowCodeFlow != null && isLowCodeFlow == 1;
        if (!lowCodeFlowFlag) {
            return;
        }
        Long confId = confVo.getId();
        List bpmnConfLfFormdataList = this.lfFormdataService.list((Wrapper)Wrappers.lambdaQuery().eq(BpmnConfLfFormdata::getBpmnConfId, (Object)confId));
        if (CollectionUtils.isEmpty((Collection)bpmnConfLfFormdataList)) {
            throw new AFBizException(Strings.lenientFormat((String)"can not get lowcode flow formdata by confId:%s", (Object[])new Object[]{confId}));
        }
        BpmnConfLfFormdata lfFormdata = (BpmnConfLfFormdata)bpmnConfLfFormdataList.get(0);
        confVo.setLfFormData(lfFormdata.getFormdata());
        confVo.setLfFormDataId(lfFormdata.getId());
    }

    private void parseWidgetListRecursively(List<FormConfigWrapper.LFWidget> widgetList, Long confId, Long formDataId, List<BpmnConfLfFormdataField> result) {
        for (FormConfigWrapper.LFWidget lfWidget : widgetList) {
            if (!"container".equals(lfWidget.getCategory())) {
                FormConfigWrapper.LFWidget.LFOption lfOption = lfWidget.getOptions();
                BpmnConfLfFormdataField formdataField = new BpmnConfLfFormdataField();
                formdataField.setBpmnConfId(confId);
                formdataField.setFormDataId(formDataId);
                formdataField.setFieldType(lfOption.getFieldType());
                formdataField.setFieldId(lfOption.getName());
                formdataField.setFieldName(lfOption.getLabel());
                result.add(formdataField);
                continue;
            }
            String containerType = lfWidget.getType();
            VariantFormContainerTypeEnum containerTypeEnum = VariantFormContainerTypeEnum.getByTypeName((String)containerType);
            if (containerTypeEnum == null) continue;
            if (VariantFormContainerTypeEnum.CARD.equals((Object)containerTypeEnum)) {
                List subWidgetList = lfWidget.getWidgetList();
                this.parseWidgetListRecursively(subWidgetList, confId, formDataId, result);
                continue;
            }
            if (VariantFormContainerTypeEnum.TAB.equals((Object)containerTypeEnum)) {
                List tabs = lfWidget.getTabs();
                for (FormConfigWrapper.LFWidget tab : tabs) {
                    List subWidgetList = tab.getWidgetList();
                    this.parseWidgetListRecursively(subWidgetList, confId, formDataId, result);
                }
                continue;
            }
            List rows = lfWidget.getRows();
            if (!CollectionUtils.isEmpty((Collection)rows)) {
                for (FormConfigWrapper.TableRow row : lfWidget.getRows()) {
                    List cols = row.getCols();
                    for (FormConfigWrapper.LFWidget col : cols) {
                        List subWidgetList = col.getWidgetList();
                        if (CollectionUtils.isEmpty((Collection)subWidgetList)) continue;
                        this.parseWidgetListRecursively(subWidgetList, confId, formDataId, result);
                    }
                }
                continue;
            }
            List cols = lfWidget.getCols();
            for (FormConfigWrapper.LFWidget col : cols) {
                List subWidgetList = col.getWidgetList();
                if (CollectionUtils.isEmpty((Collection)subWidgetList)) continue;
                this.parseWidgetListRecursively(subWidgetList, confId, formDataId, result);
            }
        }
    }

    public int order() {
        return 0;
    }
}

