/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.lowflow.service;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.constant.enums.LFControlTypeEnum;
import org.openoa.base.constant.enums.LFFieldTypeEnum;
import org.openoa.base.entity.BpmnConfLfFormdata;
import org.openoa.base.entity.BpmnConfLfFormdataField;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ActivitiService;
import org.openoa.base.interf.ActivitiServiceAnno;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.util.DateUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.SnowFlake;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.BpmnConfLfFormdataFieldServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnConfLfFormdataServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.LFMainFieldServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.LFMainServiceImpl;
import org.openoa.engine.lowflow.entity.LFMain;
import org.openoa.engine.lowflow.entity.LFMainField;
import org.openoa.engine.lowflow.vo.UDLFApplyVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ActivitiServiceAnno(svcName="LF", desc="")
public class LowFlowApprovalService
implements FormOperationAdaptor<UDLFApplyVo>,
ActivitiService {
    private static final Logger log = LoggerFactory.getLogger(LowFlowApprovalService.class);
    private static Map<Long, List<String>> conditionFieldNameMap = new HashMap<Long, List<String>>();
    private static Map<Long, Map<String, BpmnConfLfFormdataField>> allFieldConfMap = new HashMap<Long, Map<String, BpmnConfLfFormdataField>>();
    @Autowired
    private BpmnConfLfFormdataFieldServiceImpl lfFormdataFieldService;
    @Autowired
    private LFMainFieldServiceImpl mainFieldService;
    @Autowired
    private LFMainServiceImpl mainService;
    @Autowired
    private BpmnConfLfFormdataServiceImpl lfFormdataService;

    public BpmnStartConditionsVo previewSetCondition(UDLFApplyVo vo) {
        String userId = vo.getStartUserId();
        BpmnStartConditionsVo startConditionsVo = BpmnStartConditionsVo.builder().isLowCodeFlow(true).startUserId(userId).build();
        if (!CollectionUtils.isEmpty((Map)vo.getLfConditions())) {
            startConditionsVo.setLfConditions(vo.getLfConditions());
        } else {
            startConditionsVo.setLfConditions(vo.getLfFields());
        }
        return startConditionsVo;
    }

    public UDLFApplyVo initData(UDLFApplyVo vo) {
        return null;
    }

    public BpmnStartConditionsVo launchParameters(UDLFApplyVo vo) {
        String userId = vo.getStartUserId();
        BpmnStartConditionsVo startConditionsVo = BpmnStartConditionsVo.builder().isLowCodeFlow(true).startUserId(userId).build();
        if (!CollectionUtils.isEmpty((Map)vo.getLfConditions())) {
            startConditionsVo.setLfConditions(vo.getLfConditions());
        } else {
            startConditionsVo.setLfConditions(vo.getLfFields());
        }
        return startConditionsVo;
    }

    public UDLFApplyVo queryData(UDLFApplyVo vo) {
        LFMain lfMain = (LFMain)this.mainService.getById((Serializable)((Object)vo.getBusinessId()));
        if (lfMain == null) {
            log.error("can not get lowcode from data by specified Id:{}", (Object)vo.getBusinessId());
            throw new AFBizException("can not get lowcode form data by specified id");
        }
        Long mainId = lfMain.getId();
        Long confId = lfMain.getConfId();
        String formCode = lfMain.getFormCode();
        Map<String, BpmnConfLfFormdataField> lfFormdataFieldMap = allFieldConfMap.get(confId);
        if (CollectionUtils.isEmpty(lfFormdataFieldMap)) {
            Map<String, BpmnConfLfFormdataField> Id2SelfMap = this.lfFormdataFieldService.qryFormDataFieldMap(confId);
            allFieldConfMap.put(confId, Id2SelfMap);
        }
        lfFormdataFieldMap = allFieldConfMap.get(confId);
        List lfMainFields = this.mainFieldService.list((Wrapper)Wrappers.lambdaQuery().eq(LFMainField::getMainId, (Object)mainId));
        if (CollectionUtils.isEmpty((Collection)lfMainFields)) {
            throw new AFBizException(Strings.lenientFormat((String)"lowcode form with formcode:%s,confid:%s has no formdata", (Object[])new Object[]{formCode, confId}));
        }
        HashMap<String, Object> fieldVoMap = new HashMap<String, Object>(lfMainFields.size());
        Map<String, List<LFMainField>> fieldName2SelfMap = lfMainFields.stream().collect(Collectors.groupingBy(LFMainField::getFieldId));
        for (Map.Entry<String, List<LFMainField>> Id2SelfEntry : fieldName2SelfMap.entrySet()) {
            String fieldName = Id2SelfEntry.getKey();
            BpmnConfLfFormdataField currentFieldProp = lfFormdataFieldMap.get(fieldName);
            if (currentFieldProp == null) {
                throw new AFBizException(Strings.lenientFormat((String)"field with name:%s has no property", (Object[])new Object[]{fieldName}));
            }
            List<LFMainField> fields = Id2SelfEntry.getValue();
            int valueLen = fields.size();
            ArrayList<Object> actualMultiValue = valueLen == 1 ? null : new ArrayList<Object>(valueLen);
            for (LFMainField field : fields) {
                Integer fieldType = currentFieldProp.getFieldType();
                LFFieldTypeEnum fieldTypeEnum = LFFieldTypeEnum.getByType((Integer)fieldType);
                if (fieldTypeEnum == null) {
                    throw new AFBizException(Strings.lenientFormat((String)"unrecognized field type,name:%s,formcode:%s,confId:%d", (Object[])new Object[]{fieldName, formCode, confId}));
                }
                Object actualValue = null;
                switch (fieldTypeEnum) {
                    case STRING: {
                        actualValue = field.getFieldValue();
                        if (actualValue == null) break;
                        String actualValueString = actualValue.toString();
                        if (actualValueString.startsWith("{")) {
                            actualValue = JSON.parseObject((String)actualValueString);
                            break;
                        }
                        if (!actualValueString.startsWith("[")) break;
                        actualValue = JSON.parseArray((String)actualValueString);
                        break;
                    }
                    case NUMBER: {
                        if (LFControlTypeEnum.SELECT.getName().equals(currentFieldProp.getFieldName())) {
                            try {
                                Object parse = JSON.parse((String)field.getFieldValue());
                                if (parse == null) {
                                    actualValue = "";
                                    break;
                                }
                                if (parse instanceof JSONArray) {
                                    actualValue = JSON.parseArray((String)field.getFieldValue());
                                    break;
                                }
                                actualValue = parse;
                            }
                            catch (Exception e) {
                                log.warn("field value can not be parsed to number,fieldName:{},formCode:{},confId:{}", new Object[]{fieldName, formCode, confId});
                                actualValue = field.getFieldValue();
                            }
                            break;
                        }
                        actualValue = field.getFieldValueNumber();
                        break;
                    }
                    case DATE_TIME: {
                        actualValue = DateUtil.SDF_DATETIME_PATTERN.format(field.getFieldValueDt());
                        break;
                    }
                    case DATE: {
                        actualValue = DateUtil.SDF_DATE_PATTERN.format(field.getFieldValueDt());
                        break;
                    }
                    case TEXT: {
                        actualValue = field.getFieldValueText();
                        break;
                    }
                    case BOOLEAN: {
                        actualValue = Boolean.parseBoolean(field.getFieldValue());
                    }
                }
                if (valueLen == 1) {
                    fieldVoMap.put(fieldName, actualValue);
                    break;
                }
                actualMultiValue.add(actualValue);
            }
            if (CollectionUtils.isEmpty(actualMultiValue)) continue;
            fieldVoMap.put(fieldName, actualMultiValue);
        }
        vo.setLfFields(fieldVoMap);
        List bpmnConfLfFormdataList = this.lfFormdataService.list((Wrapper)Wrappers.lambdaQuery().eq(BpmnConfLfFormdata::getBpmnConfId, (Object)confId));
        if (CollectionUtils.isEmpty((Collection)bpmnConfLfFormdataList)) {
            throw new AFBizException(Strings.lenientFormat((String)"can not get lowcode flow formdata by confId:%s", (Object[])new Object[]{confId}));
        }
        BpmnConfLfFormdata lfFormdata = (BpmnConfLfFormdata)bpmnConfLfFormdataList.get(0);
        vo.setLfFormData(lfFormdata.getFormdata());
        return vo;
    }

    public UDLFApplyVo submitData(UDLFApplyVo vo) {
        Map<String, BpmnConfLfFormdataField> fieldConfMap;
        Map<String, Object> lfFields = vo.getLfFields();
        if (CollectionUtils.isEmpty(lfFields)) {
            throw new AFBizException("form data does not contains any field");
        }
        Long confId = vo.getBpmnConfVo().getId();
        String formCode = vo.getFormCode();
        LFMain main = new LFMain();
        main.setId(SnowFlake.nextId());
        main.setConfId(confId);
        main.setFormCode(formCode);
        main.setCreateUser(SecurityUtils.getLogInEmpName());
        this.mainService.save(main);
        Long mainId = main.getId();
        Map<String, BpmnConfLfFormdataField> lfFormdataFieldMap = allFieldConfMap.get(confId);
        if (CollectionUtils.isEmpty(lfFormdataFieldMap)) {
            Map<String, BpmnConfLfFormdataField> name2SelfMap = this.lfFormdataFieldService.qryFormDataFieldMap(confId);
            allFieldConfMap.put(confId, name2SelfMap);
        }
        if (CollectionUtils.isEmpty(fieldConfMap = allFieldConfMap.get(confId))) {
            throw new AFBizException(Strings.lenientFormat((String)"confId %s,formCode:%s does not has a field config", (Object[])new Object[]{confId, vo.getFormCode()}));
        }
        List<LFMainField> mainFields = LFMainField.parseFromMap(lfFields, fieldConfMap, mainId, formCode);
        this.mainFieldService.saveBatch(mainFields);
        vo.setBusinessId(mainId.toString());
        vo.setProcessDigest(vo.getRemark());
        vo.setEntityName(LowFlowApprovalService.class.getSimpleName());
        return vo;
    }

    public UDLFApplyVo consentData(UDLFApplyVo vo) {
        if (!vo.getOperationType().equals(ButtonTypeEnum.BUTTON_TYPE_RESUBMIT.getCode()) && !vo.getOperationType().equals(ButtonTypeEnum.BUTTON_TYPE_AGREE.getCode())) {
            return vo;
        }
        Map<String, Object> lfFields = vo.getLfFields();
        if (CollectionUtils.isEmpty(lfFields)) {
            throw new AFBizException("form data does not contains any field");
        }
        LFMain lfMain = (LFMain)this.mainService.getById((Serializable)((Object)vo.getBusinessId()));
        if (lfMain == null) {
            log.error("can not get lowcode from data by specified Id:{}", (Object)vo.getBusinessId());
            throw new AFBizException("can not get lowcode form data by specified id");
        }
        Long mainId = lfMain.getId();
        String formCode = vo.getFormCode();
        Long confId = vo.getBpmnConfVo().getId();
        List lfMainFields = this.mainFieldService.list((Wrapper)Wrappers.lambdaQuery().eq(LFMainField::getMainId, (Object)mainId));
        Map<String, Object> submitLfFields = vo.getLfFields();
        if (ObjectUtils.isNotEmpty(submitLfFields)) {
            Map<String, BpmnConfLfFormdataField> fieldConfMap;
            Map<String, BpmnConfLfFormdataField> lfFormdataFieldMap = allFieldConfMap.get(confId);
            if (ObjectUtils.isEmpty(lfFormdataFieldMap)) {
                Map<String, BpmnConfLfFormdataField> name2SelfMap = this.lfFormdataFieldService.qryFormDataFieldMap(confId);
                allFieldConfMap.put(confId, name2SelfMap);
            }
            if (ObjectUtils.isEmpty(fieldConfMap = allFieldConfMap.get(confId))) {
                throw new AFBizException(Strings.lenientFormat((String)"confId %s,formCode:%s does not has a field config", (Object[])new Object[]{confId, vo.getFormCode()}));
            }
            List<LFMainField> mainFields = LFMainField.parseFromMap(submitLfFields, fieldConfMap, mainId, vo.getFormCode());
            if (CollectionUtils.isNotEmpty(mainFields)) {
                mainFields.removeIf(mainField -> lfMainFields.stream().anyMatch(ori -> ori.getFieldId().equals(mainField.getFieldId())));
                this.mainFieldService.saveBatch(mainFields);
            }
        }
        if (CollectionUtils.isEmpty((Collection)lfMainFields)) {
            throw new AFBizException(Strings.lenientFormat((String)"lowcode form with formcode:%s,confid:%s has no formdata", (Object[])new Object[]{formCode, confId}));
        }
        for (LFMainField field : lfMainFields) {
            String f_value = lfFields.get(field.getFieldId()).toString();
            if (!Objects.equals(f_value, "******")) {
                field.setFieldValue(f_value);
            }
            this.mainFieldService.updateById(field);
        }
        return vo;
    }

    public void backToModifyData(UDLFApplyVo vo) {
    }

    public void cancellationData(UDLFApplyVo vo) {
    }

    public void finishData(BusinessDataVo vo) {
    }

    private Map<String, Object> filterConditionFields(UDLFApplyVo vo) {
        Long confId = vo.getBpmnConfVo().getId();
        List<String> conditionFieldNames = conditionFieldNameMap.get(confId);
        HashMap<String, Object> conditionFieldMap = null;
        if (CollectionUtils.isEmpty(conditionFieldNames)) {
            List allFields;
            HashMap<String, Object> lfConditions = vo.getLfConditions();
            if (!CollectionUtils.isEmpty((Map)lfConditions)) {
                conditionFieldMap = lfConditions;
            }
            if (CollectionUtils.isEmpty((Collection)(allFields = this.lfFormdataFieldService.list((Wrapper)Wrappers.lambdaQuery().eq(BpmnConfLfFormdataField::getBpmnConfId, (Object)confId))))) {
                throw new AFBizException("lowcode form data has no fields");
            }
            ArrayList<String> condFieldNames = new ArrayList<String>();
            HashMap<String, BpmnConfLfFormdataField> Id2SelfMap = new HashMap<String, BpmnConfLfFormdataField>();
            for (BpmnConfLfFormdataField field : allFields) {
                String fieldId = field.getFieldId();
                Id2SelfMap.put(fieldId, field);
                if (field.getIsConditionField() == null || field.getIsConditionField() != 1) continue;
                condFieldNames.add(fieldId);
            }
            conditionFieldNameMap.put(confId, condFieldNames);
            if (!allFieldConfMap.containsKey(confId)) {
                allFieldConfMap.put(confId, Id2SelfMap);
            }
        }
        if (!CollectionUtils.isEmpty(conditionFieldNames = conditionFieldNameMap.get(confId))) {
            conditionFieldMap = new HashMap<String, Object>();
            Map<String, Object> lfFields = vo.getLfFields();
            for (Map.Entry<String, Object> stringObjectEntry : lfFields.entrySet()) {
                String key = stringObjectEntry.getKey();
                if (!conditionFieldNames.contains(key)) continue;
                conditionFieldMap.put(key, stringObjectEntry.getValue());
            }
        }
        if (!CollectionUtils.isEmpty((Map)conditionFieldMap) && conditionFieldMap.size() > 1) {
            throw new AFBizException("conditionFields size can not greater than 1");
        }
        return conditionFieldMap;
    }
}

