/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;

public class BoundSqlUtils {
    public static List<Map.Entry<String, String>> extractWhereColumnsAndParams(BoundSql boundSql) {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        String sql = boundSql.getSql();
        List mappings = boundSql.getParameterMappings();
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)sql);
            final ArrayList columnNames = new ArrayList();
            stmt.accept((StatementVisitor)new StatementVisitorAdapter(){

                public void visit(Select select) {
                    PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
                    Expression where = plainSelect.getWhere();
                    if (where != null) {
                        BoundSqlUtils.parseWhere(where, columnNames);
                    }
                }

                public void visit(Update update) {
                    Expression where = update.getWhere();
                    if (where != null) {
                        BoundSqlUtils.parseWhere(where, columnNames);
                    }
                }

                public void visit(Delete delete) {
                    Expression where = delete.getWhere();
                    if (where != null) {
                        BoundSqlUtils.parseWhere(where, columnNames);
                    }
                }
            });
            int count = Math.min(columnNames.size(), mappings.size());
            for (int i = 0; i < count; ++i) {
                String column = (String)columnNames.get(i);
                String property = ((ParameterMapping)mappings.get(i)).getProperty();
                result.add(new AbstractMap.SimpleEntry<String, String>(column, property));
            }
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("\u89e3\u6790SQL\u51fa\u9519", e);
        }
        return result;
    }

    private static void parseWhere(Expression where, final List<String> columns) {
        ExpressionDeParser deParser = new ExpressionDeParser(){

            public void visit(AndExpression andExpression) {
                andExpression.getLeftExpression().accept((ExpressionVisitor)this);
                andExpression.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(EqualsTo equalsTo) {
                if (equalsTo.getRightExpression() instanceof JdbcParameter) {
                    columns.add(equalsTo.getLeftExpression().toString());
                }
                equalsTo.getLeftExpression().accept((ExpressionVisitor)this);
                equalsTo.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(GreaterThan greaterThan) {
                if (greaterThan.getRightExpression() instanceof JdbcParameter) {
                    columns.add(greaterThan.getLeftExpression().toString());
                }
                greaterThan.getLeftExpression().accept((ExpressionVisitor)this);
                greaterThan.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(GreaterThanEquals greaterThanEquals) {
                if (greaterThanEquals.getRightExpression() instanceof JdbcParameter) {
                    columns.add(greaterThanEquals.getLeftExpression().toString());
                }
                greaterThanEquals.getLeftExpression().accept((ExpressionVisitor)this);
                greaterThanEquals.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(MinorThan minorThan) {
                if (minorThan.getRightExpression() instanceof JdbcParameter) {
                    columns.add(minorThan.getLeftExpression().toString());
                }
                minorThan.getLeftExpression().accept((ExpressionVisitor)this);
                minorThan.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(MinorThanEquals minorThanEquals) {
                if (minorThanEquals.getRightExpression() instanceof JdbcParameter) {
                    columns.add(minorThanEquals.getLeftExpression().toString());
                }
                minorThanEquals.getLeftExpression().accept((ExpressionVisitor)this);
                minorThanEquals.getRightExpression().accept((ExpressionVisitor)this);
            }

            public void visit(NotEqualsTo notEqualsTo) {
                if (notEqualsTo.getRightExpression() instanceof JdbcParameter) {
                    columns.add(notEqualsTo.getLeftExpression().toString());
                }
                notEqualsTo.getLeftExpression().accept((ExpressionVisitor)this);
                notEqualsTo.getRightExpression().accept((ExpressionVisitor)this);
            }
        };
        where.accept((ExpressionVisitor)deParser);
    }

    public static boolean isCurdSql(String sql) {
        if (sql == null || sql.trim().isEmpty()) {
            return false;
        }
        String lowerSql = sql.toLowerCase(Locale.ROOT);
        Pattern pattern = Pattern.compile("\\b(insert|update|delete|select)\\b");
        Matcher matcher = pattern.matcher(lowerSql);
        return matcher.find();
    }

    private static String removeLeadingCommentsAndWhitespace(String sql) {
        String trimmed = sql.trim();
        while (trimmed.startsWith("--") || trimmed.startsWith("/*")) {
            if (trimmed.startsWith("--")) {
                int newline = trimmed.indexOf(10);
                trimmed = newline >= 0 ? trimmed.substring(newline + 1).trim() : "";
                continue;
            }
            if (!trimmed.startsWith("/*")) continue;
            int endComment = trimmed.indexOf("*/");
            trimmed = endComment >= 0 ? trimmed.substring(endComment + 2).trim() : "";
        }
        return trimmed;
    }

    private static String getFirstKeyword(String sql) {
        if (sql.isEmpty()) {
            return "";
        }
        String[] parts = sql.split("\\s+", 2);
        return parts[0];
    }

    private static boolean isFixedValue(Expression rightExpression) {
        return rightExpression instanceof LongValue || rightExpression instanceof StringValue || rightExpression instanceof DoubleValue || rightExpression instanceof NullValue || rightExpression instanceof DateValue || rightExpression instanceof TimeValue || rightExpression instanceof TimestampValue;
    }
}

