/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openoa.base.constant.enums.ConditionRelationShipEnum;
import org.openoa.base.constant.enums.JudgeOperatorEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BaseKeyValueStruVo;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnNodeConditionsConfVueVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.engine.bpmnconf.constant.enus.ConditionTypeEnum;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class BpmnConfNodePropertyConverter {
    public static BpmnNodeConditionsConfBaseVo fromVue3Model(BpmnNodePropertysVo propertysVo) {
        if (propertysVo == null) {
            throw new AFBizException("node has no property!");
        }
        Integer isDefault = propertysVo.getIsDefault();
        HashMap groupedLfConditionsMap = new HashMap();
        BpmnNodeConditionsConfBaseVo result = new BpmnNodeConditionsConfBaseVo();
        result.setIsDefault(propertysVo.getIsDefault());
        result.setSort(propertysVo.getSort());
        result.setGroupRelation(ConditionRelationShipEnum.getCodeByValue((Boolean)propertysVo.getGroupRelation()));
        ArrayList<Integer> conditionTypes = new ArrayList<Integer>();
        HashMap groupedConditionTypes = new HashMap();
        Integer strEnumCode = ConditionTypeEnum.CONDITION_TYPE_LF_STR_CONDITION.getCode();
        boolean isLowCodeFlow = false;
        List groupedNewModels = propertysVo.getConditionList();
        if (ObjectUtils.isEmpty((Object)groupedNewModels) && Objects.equals(isDefault, 0)) {
            throw new AFBizException("input nodes is empty");
        }
        int index = 0;
        for (List newModels : groupedNewModels) {
            HashMap<String, Object> wrapperResult = new HashMap<String, Object>();
            ++index;
            ArrayList<Integer> currentGroupConditionTypes = new ArrayList<Integer>();
            for (BpmnNodeConditionsConfVueVo newModel : newModels) {
                HashMap<String, Object> valueOrWrapper;
                ConditionTypeEnum enumByCode;
                newModel.setCondGroup(Integer.valueOf(index));
                String columnId = newModel.getColumnId();
                if (columnId == null) {
                    throw new AFBizException("each and every node must have a columnId value");
                }
                int columnIdInt = Integer.parseInt(columnId);
                if (strEnumCode == columnIdInt && newModel.getMultiple() != null && newModel.getMultiple().booleanValue()) {
                    columnIdInt = ConditionTypeEnum.CONDITION_TYPE_LF_COLLECTION_CONDITION.getCode();
                }
                if ((enumByCode = ConditionTypeEnum.getEnumByCode(columnIdInt)) == null) {
                    throw new AFBizException(String.format("columnId of value:%s is not a valid value", columnId));
                }
                conditionTypes.add(columnIdInt);
                currentGroupConditionTypes.add(columnIdInt);
                String fieldName = enumByCode.getFieldName();
                String columnDbname = newModel.getColumnDbname();
                if (!(fieldName.equals(columnDbname) || StringUtil.isEmpty((CharSequence)columnDbname) || "lfConditions".equals(fieldName))) {
                    throw new AFBizException(String.format("columnDbname:%s is not a valid name", columnDbname));
                }
                Integer fieldType = enumByCode.getFieldType();
                Class<?> fieldCls = enumByCode.getFieldCls();
                if (fieldType == 1) {
                    String fixedDownBoxValue = newModel.getFixedDownBoxValue();
                    List valueStruVoList = JSON.parseArray((String)fixedDownBoxValue, BaseKeyValueStruVo.class);
                    String zdy1 = newModel.getZdy1();
                    if (zdy1.startsWith("[") && zdy1.endsWith("]")) {
                        zdy1 = zdy1.substring(1, zdy1.length() - 1);
                    }
                    String[] keys = zdy1.split(",");
                    List<String> keysList = Arrays.asList(keys);
                    ArrayList values = new ArrayList(keys.length);
                    keysList.forEach(key -> {
                        BaseKeyValueStruVo baseKeyValueStruVo = valueStruVoList.stream().filter(x -> x.getKey().equals(key)).findFirst().get();
                        if (fieldCls.equals(String.class)) {
                            values.add(baseKeyValueStruVo.getKey());
                        } else {
                            Object parsedObject = JSON.parseObject((String)baseKeyValueStruVo.getKey(), (Class)fieldCls);
                            values.add(parsedObject);
                        }
                    });
                    valueOrWrapper = null;
                    if (ConditionTypeEnum.isLowCodeFlow(enumByCode)) {
                        isLowCodeFlow = true;
                        wrapperResult.put(columnDbname, values);
                        valueOrWrapper = wrapperResult;
                        groupedLfConditionsMap.put(index, wrapperResult);
                        continue;
                    }
                    Field field = FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)enumByCode.getFieldName(), (boolean)true);
                    ReflectionUtils.setField((Field)field, (Object)result, valueOrWrapper != null ? valueOrWrapper : values);
                    continue;
                }
                String zdy1 = newModel.getZdy1();
                String zdy2 = newModel.getZdy2();
                Field field = FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)enumByCode.getFieldName(), (boolean)true);
                String opt1 = newModel.getOpt1();
                String opt2 = newModel.getOpt2();
                Integer optType = newModel.getOptType();
                if (optType != null) {
                    JudgeOperatorEnum symbol = JudgeOperatorEnum.getByOpType((Integer)optType);
                    if (symbol == null) {
                        throw new AFBizException(String.format("condition optype of %d is undefined!", optType));
                    }
                    Field opField = FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)"numberOperator", (boolean)true);
                    ReflectionUtils.setField((Field)opField, (Object)result, (Object)symbol.getCode());
                }
                if (String.class.isAssignableFrom(fieldCls)) {
                    valueOrWrapper = null;
                    if (JudgeOperatorEnum.binaryOperator().contains(optType)) {
                        zdy1 = zdy1 + "," + zdy2;
                    }
                    if (ConditionTypeEnum.isLowCodeFlow(enumByCode)) {
                        isLowCodeFlow = true;
                        wrapperResult.put(columnDbname, zdy1);
                        valueOrWrapper = wrapperResult;
                        groupedLfConditionsMap.put(index, wrapperResult);
                        continue;
                    }
                    ReflectionUtils.setField((Field)field, (Object)result, (Object)(valueOrWrapper != null ? valueOrWrapper : zdy1));
                    continue;
                }
                valueOrWrapper = null;
                Object actualValue = null;
                Object zdy2Value = null;
                actualValue = JSON.parseObject((String)zdy1, fieldCls);
                if (!StringUtils.isEmpty((CharSequence)zdy2)) {
                    zdy2Value = JSON.parseObject((String)zdy2, fieldCls);
                }
                if (JudgeOperatorEnum.binaryOperator().contains(optType)) {
                    zdy1 = zdy1 + "," + zdy2;
                }
                if (ConditionTypeEnum.isLowCodeFlow(enumByCode)) {
                    isLowCodeFlow = true;
                    wrapperResult.put(columnDbname, actualValue);
                    valueOrWrapper = wrapperResult;
                    groupedLfConditionsMap.put(index, wrapperResult);
                    continue;
                }
                ReflectionUtils.setField((Field)field, (Object)result, (Object)(valueOrWrapper != null ? valueOrWrapper : actualValue));
            }
            groupedConditionTypes.put(index, currentGroupConditionTypes);
        }
        if (isLowCodeFlow) {
            result.setGroupedLfConditionsMap(groupedLfConditionsMap);
        }
        String extJson = JSON.toJSONString((Object)groupedNewModels);
        result.setExtJson(extJson);
        result.setConditionParamTypes(conditionTypes);
        result.setGroupedConditionParamTypes(groupedConditionTypes);
        return result;
    }

    public static List<BpmnNodeConditionsConfVueVo> toVue3Model(BpmnNodeConditionsConfBaseVo baseVo) {
        if (baseVo == null) {
            throw new AFBizException("baseVo to convert is null");
        }
        if (Objects.equals(baseVo.getIsDefault(), 1)) {
            return new ArrayList<BpmnNodeConditionsConfVueVo>();
        }
        ArrayList<BpmnNodeConditionsConfVueVo> results = new ArrayList<BpmnNodeConditionsConfVueVo>();
        Map groupedConditionParamTypes = baseVo.getGroupedConditionParamTypes() != null ? baseVo.getGroupedConditionParamTypes() : new HashMap();
        String extJson = baseVo.getExtJson();
        Map<Object, Object> groupedConditionsConf = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)extJson)) {
            List extFieldsArray = (List)JSON.parseObject((String)extJson, (TypeReference)new TypeReference<List<List<BpmnNodeConditionsConfVueVo>>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
            groupedConditionsConf = extFieldsArray.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(BpmnNodeConditionsConfVueVo::getCondGroup));
        }
        for (Map.Entry integerListEntry : groupedConditionParamTypes.entrySet()) {
            Integer group = (Integer)integerListEntry.getKey();
            List bpmnNodeConditionsConfVueVos = (List)groupedConditionsConf.get(group);
            List conditionParamTypes = (List)integerListEntry.getValue();
            int index = 0;
            for (Integer conditionParamType : conditionParamTypes) {
                ++index;
                BpmnNodeConditionsConfVueVo vueVo = new BpmnNodeConditionsConfVueVo();
                ConditionTypeEnum enumByCode = ConditionTypeEnum.getEnumByCode(conditionParamType);
                vueVo.setColumnDbname(enumByCode.getFieldName());
                Integer fieldType = enumByCode.getFieldType();
                vueVo.setShowName(enumByCode.getDesc());
                if (fieldType == 1) {
                    Field field = FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)enumByCode.getFieldName(), (boolean)true);
                    Map wrappedValues = null;
                    List objects = new ArrayList();
                    if (ConditionTypeEnum.isLowCodeFlow(enumByCode)) {
                        wrappedValues = (Map)ReflectionUtils.getField((Field)field, (Object)baseVo);
                        Collection values = wrappedValues.values();
                        for (Collection value : values) {
                            objects.addAll(value);
                        }
                    } else {
                        objects = (List)ReflectionUtils.getField((Field)field, (Object)baseVo);
                    }
                    String join = Joiner.on((String)",").join(objects);
                    vueVo.setZdy1(join);
                    Field extField = null;
                    extField = ConditionTypeEnum.isLowCodeFlow(enumByCode) ? field : FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)(enumByCode.getFieldName() + "List"), (boolean)true);
                    List extFields = null;
                    if (ConditionTypeEnum.isLowCodeFlow(enumByCode)) {
                        String fixedDownBoxValue;
                        if (!CollectionUtils.isEmpty((Collection)bpmnNodeConditionsConfVueVos) && !StringUtils.isEmpty((CharSequence)(fixedDownBoxValue = ((BpmnNodeConditionsConfVueVo)bpmnNodeConditionsConfVueVos.get(index - 1)).getFixedDownBoxValue()))) {
                            vueVo.setFixedDownBoxValue(fixedDownBoxValue);
                        }
                    } else {
                        extFields = (List)ReflectionUtils.getField((Field)extField, (Object)baseVo);
                    }
                    if (CollectionUtils.isEmpty(extFields)) continue;
                    ArrayList<BaseKeyValueStruVo> keyValuePairVos = new ArrayList<BaseKeyValueStruVo>();
                    for (BaseIdTranStruVo baseIdTranStruVo : extFields) {
                        BaseKeyValueStruVo keyValuePairVo = new BaseKeyValueStruVo();
                        keyValuePairVo.setKey(baseIdTranStruVo.getId());
                        keyValuePairVo.setValue(baseIdTranStruVo.getName());
                        keyValuePairVos.add(keyValuePairVo);
                    }
                    String extJsonx = JSON.toJSONString(keyValuePairVos);
                    vueVo.setFixedDownBoxValue(extJsonx);
                }
                results.add(vueVo);
            }
        }
        return results;
    }
}

