/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.task.Task;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableSignUpPersonnel;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.entity.BpmVariableMultiplayerPersonnel;
import org.openoa.common.entity.BpmVariableSingle;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.mapper.BpmVariableMultiplayerPersonnelMapper;
import org.openoa.common.mapper.BpmVariableSingleMapper;
import org.openoa.common.service.BpmVariableMultiplayerPersonnelServiceImpl;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.common.service.BpmVariableSingleServiceImpl;
import org.openoa.engine.bpmnconf.common.ActivitiAdditionalInfoServiceImpl;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMapper;
import org.openoa.engine.bpmnconf.mapper.BpmVariableSignUpPersonnelMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableSignUpPersonnelServiceImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnUtils
implements ApplicationContextAware {
    private static ActivitiAdditionalInfoServiceImpl activitiAdditionalInfoService;
    private static BpmVariableServiceImpl bpmVariableService;
    private static BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService;
    private static BpmVariableSignUpPersonnelServiceImpl bpmVariableSignUpPersonnelService;
    private static BpmVariableMultiplayerPersonnelServiceImpl bpmVariableMultiplayerPersonnelService;
    private static BpmVariableSingleServiceImpl bpmVariableSingleService;
    private static BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    private static Environment environment;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        activitiAdditionalInfoService = (ActivitiAdditionalInfoServiceImpl)applicationContext.getBean(ActivitiAdditionalInfoServiceImpl.class);
        bpmVariableService = (BpmVariableServiceImpl)((Object)applicationContext.getBean(BpmVariableServiceImpl.class));
        bpmVariableMultiplayerService = (BpmVariableMultiplayerServiceImpl)applicationContext.getBean(BpmVariableMultiplayerServiceImpl.class);
        bpmVariableSignUpPersonnelService = (BpmVariableSignUpPersonnelServiceImpl)((Object)applicationContext.getBean(BpmVariableSignUpPersonnelServiceImpl.class));
        bpmBusinessProcessService = (BpmBusinessProcessServiceImpl)((Object)applicationContext.getBean(BpmBusinessProcessServiceImpl.class));
        bpmVariableMultiplayerPersonnelService = (BpmVariableMultiplayerPersonnelServiceImpl)applicationContext.getBean(BpmVariableMultiplayerPersonnelServiceImpl.class);
        bpmVariableSingleService = (BpmVariableSingleServiceImpl)applicationContext.getBean(BpmVariableSingleServiceImpl.class);
        environment = applicationContext.getEnvironment();
    }

    public static PvmActivity getNextElement(String elementId, String processInstanceId) {
        return activitiAdditionalInfoService.getNextElement(elementId, processInstanceId);
    }

    public static PvmActivity getNextElement(Task currentTask) {
        return BpmnUtils.getNextElement(currentTask.getTaskDefinitionKey(), currentTask.getProcessInstanceId());
    }

    public static List<String> getNextNodeApprovers(Task currentTask) {
        String elementId = currentTask.getTaskDefinitionKey();
        String processInstanceId = currentTask.getProcessInstanceId();
        PvmActivity nextElement = BpmnUtils.getNextElement(elementId, processInstanceId);
        return BpmnUtils.getNextNodeApprovers(nextElement);
    }

    public static List<String> getNextNodeApprovers(PvmActivity nextElement) {
        PvmProcessDefinition processDefinition = nextElement.getProcessDefinition();
        String processId = processDefinition.getKey();
        List bpmVariables = ((BpmVariableMapper)bpmVariableService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"process_num", (Object)processId));
        BpmVariable bpmVariable = null;
        if (!ObjectUtils.isEmpty((Object)bpmVariables)) {
            bpmVariable = (BpmVariable)bpmVariables.get(0);
        }
        if (!ObjectUtils.isEmpty((Object)nextElement) && !"endEvent".equals(nextElement.getProperty("type"))) {
            List<String> nextNodeApproveds = BpmnUtils.getNextNodeApproveds(bpmVariable.getId(), nextElement.getId());
            return nextNodeApproveds;
        }
        return Collections.EMPTY_LIST;
    }

    private static List<String> getNextNodeApproveds(Long variableId, String nextElementId) {
        if (((BpmVariableSingleMapper)bpmVariableSingleService.getBaseMapper()).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)) > 0L) {
            ArrayList nextNodeApproveds = Lists.newArrayList();
            BpmVariableSingle bpmVariableSingle = (BpmVariableSingle)((BpmVariableSingleMapper)bpmVariableSingleService.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId));
            nextNodeApproveds.add(bpmVariableSingle.getAssignee());
            return nextNodeApproveds;
        }
        if (((BpmVariableMultiplayerMapper)bpmVariableMultiplayerService.getBaseMapper()).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)) > 0L) {
            ArrayList nextNodeApproveds = Lists.newArrayList();
            BpmVariableMultiplayer bpmVariableMultiplayer = (BpmVariableMultiplayer)((BpmVariableMultiplayerMapper)bpmVariableMultiplayerService.getBaseMapper()).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId));
            nextNodeApproveds.addAll(((BpmVariableMultiplayerPersonnelMapper)bpmVariableMultiplayerPersonnelService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"variable_multiplayer_id", (Object)bpmVariableMultiplayer.getId())).stream().map(BpmVariableMultiplayerPersonnel::getAssignee).collect(Collectors.toList()));
            return nextNodeApproveds;
        }
        if (((BpmVariableSignUpPersonnelMapper)bpmVariableSignUpPersonnelService.getBaseMapper()).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)) > 0L) {
            ArrayList nextNodeApproveds = Lists.newArrayList();
            nextNodeApproveds.addAll(((BpmVariableSignUpPersonnelMapper)bpmVariableSignUpPersonnelService.getBaseMapper()).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"variable_id", (Object)variableId)).eq((Object)"element_id", (Object)nextElementId)).stream().map(BpmVariableSignUpPersonnel::getAssignee).collect(Collectors.toList()));
            return nextNodeApproveds;
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean isMultiNode(PvmActivity pvmActivity) {
        PvmProcessDefinition processDefinition = pvmActivity.getProcessDefinition();
        String processId = processDefinition.getKey();
        return BpmnUtils.isMoreNode(processId, pvmActivity.getId());
    }

    public static boolean isMoreNode(String processNum, String elementId) {
        List list = bpmVariableMultiplayerService.isMoreNode(processNum, elementId);
        System.out.println("list:" + list.size());
        return list != null && list.size() > 1 && ((BpmVariableMultiplayer)list.get(0)).getSignType() == 1;
    }

    public static boolean isOutSide(String processNum) {
        BpmBusinessProcess bpmBusinessProcess = (BpmBusinessProcess)bpmBusinessProcessService.getOne((Wrapper)Wrappers.lambdaQuery().eq(BpmBusinessProcess::getProcInstId, (Object)processNum), false);
        return bpmBusinessProcess != null && bpmBusinessProcess.getIsOutSideProcess() == 1;
    }

    public static String getEnvironmentValue(String key) {
        return environment.getProperty(key);
    }
}

