/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class ConsistentHashingAlg {
    private String[] servers = null;
    private List<String> realNodes = new LinkedList<String>();
    private SortedMap<Integer, String> virtualNodes = new TreeMap<Integer, String>();
    private final int VIRTUAL_NODES = 5;

    public ConsistentHashingAlg(String name, Integer count) {
        this.servers = new String[count.intValue()];
        Integer i = 0;
        while (i < count) {
            this.servers[i.intValue()] = name + "_" + i;
            this.realNodes.add(this.servers[i]);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        for (String str : this.realNodes) {
            for (int i2 = 0; i2 < 5; ++i2) {
                String virtualNodeName = str + "&&VN" + String.valueOf(i2);
                int hash = this.getHash(virtualNodeName);
                this.virtualNodes.put(hash, virtualNodeName);
            }
        }
    }

    public int getHash(String str) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash ^ str.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }

    public String getServer(String key) {
        String virtualNode;
        int hash = this.getHash(key);
        SortedMap<Integer, String> subMap = this.virtualNodes.tailMap(hash);
        if (subMap.isEmpty()) {
            Integer i = this.virtualNodes.firstKey();
            virtualNode = (String)this.virtualNodes.get(i);
        } else {
            Integer i = subMap.firstKey();
            virtualNode = (String)subMap.get(i);
        }
        if (StringUtils.isNotBlank((CharSequence)virtualNode)) {
            return virtualNode.substring(0, virtualNode.indexOf("&&"));
        }
        return null;
    }
}

