/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpClientUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static RestTemplate restTemplate;

    public static String doGet(String url) {
        return HttpClientUtil.doGet(url, null, null, String.class);
    }

    public static String doGet(String url, HttpHeaders headers) {
        return HttpClientUtil.doGet(url, headers, null, String.class);
    }

    public static <T> T doGet(String url, HttpHeaders headers, Map<String, String> param, Class<T> cls) {
        try {
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            URI uri = builder.build();
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            ResponseEntity exchange = restTemplate.exchange(uri, HttpMethod.GET, requestEntity, cls);
            Object body = exchange.getBody();
            return (T)body;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPostForm(String url, MultiValueMap<String, String> params) {
        return HttpClientUtil.doPostForm(url, params, null, String.class);
    }

    public static String doPostForm(String url, MultiValueMap<String, String> params, HttpHeaders headers) {
        return HttpClientUtil.doPostForm(url, params, headers, String.class);
    }

    public static <T> T doPostForm(String url, MultiValueMap<String, String> params, HttpHeaders headers, Class<T> cls) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity exchange = restTemplate.exchange(url, HttpMethod.POST, requestEntity, cls, new Object[0]);
        Object body = exchange.getBody();
        return (T)body;
    }

    public static String doPostJson(String url, Object body) {
        return HttpClientUtil.doPostJson(url, body, null, String.class);
    }

    public static String doPostJson(String url, Object body, HttpHeaders headers) {
        return HttpClientUtil.doPostJson(url, body, headers, String.class);
    }

    public static String doPostXml(String url, Object body) {
        return HttpClientUtil.doPostContent(url, body, null, MediaType.APPLICATION_XML, String.class);
    }

    public static <T> T doPostJson(String url, Object body, HttpHeaders headers, Class<T> tClass) {
        return HttpClientUtil.doPostContent(url, body, headers, MediaType.APPLICATION_JSON, tClass);
    }

    public static <T> T doPostContent(String url, Object body, HttpHeaders headers, MediaType mediaType, Class<T> tClass) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.setContentType(mediaType);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity exchange = restTemplate.exchange(url, HttpMethod.POST, requestEntity, tClass, new Object[0]);
        Object result = exchange.getBody();
        return (T)result;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        restTemplate = (RestTemplate)applicationContext.getBean(RestTemplate.class);
    }
}

