/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.openoa.base.constant.enums.WildcardCharacterEnum;
import org.openoa.base.entity.InformationTemplate;
import org.openoa.base.vo.InformationTemplateVo;
import org.openoa.engine.bpmnconf.mapper.InformationTemplateMapper;
import org.openoa.engine.bpmnconf.service.impl.InformationTemplateServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class InformationTemplateUtils {
    @Resource
    private InformationTemplateServiceImpl informationTemplateService;

    public InformationTemplateVo translateInformationTemplate(InformationTemplateVo informationTemplateVo) {
        InformationTemplate informationTemplate = (InformationTemplate)Optional.ofNullable(((InformationTemplateMapper)this.informationTemplateService.getBaseMapper()).selectById(informationTemplateVo.getId())).orElse(new InformationTemplate());
        return InformationTemplateVo.builder().systemTitle(this.translate(informationTemplate.getSystemTitle(), informationTemplateVo.getWildcardCharacterMap())).systemContent(this.translate(informationTemplate.getSystemContent(), informationTemplateVo.getWildcardCharacterMap())).mailTitle(this.translate(informationTemplate.getSystemTitle(), informationTemplateVo.getWildcardCharacterMap())).mailContent(this.translate(informationTemplate.getSystemContent(), informationTemplateVo.getWildcardCharacterMap())).noteContent(this.translate(informationTemplate.getNoteContent(), informationTemplateVo.getWildcardCharacterMap())).jumpUrl(informationTemplate.getJumpUrl()).build();
    }

    private String translate(String info, Map<Integer, String> map) {
        if (ObjectUtils.isEmpty((Object)info)) {
            return "";
        }
        for (WildcardCharacterEnum o : WildcardCharacterEnum.values()) {
            String pattern = o.getTransfDesc();
            String replacement = !ObjectUtils.isEmpty((Object)map.get(o.getCode())) ? map.get(o.getCode()) : "";
            info = info.replaceAll(pattern, replacement);
        }
        return info;
    }
}

