/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String transfer2JsonString(T value) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)sw);
            mapper.writeValue(gen, value);
            gen.close();
        }
        catch (IOException var5) {
            logger.error(var5.getMessage(), (Object)("value=[" + value + "]"));
        }
        return sw.toString();
    }

    public static Map<String, Object> parseRaw(String jsonStr) {
        Map result = null;
        try {
            result = (Map)mapper.readValue(jsonStr, Map.class);
        }
        catch (JsonProcessingException e) {
            log.error("json deserialize error occur");
        }
        return result;
    }

    static {
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

