/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import java.util.Map;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BusinessDataVo;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelEvaluator {
    public static boolean evaluate(String expression, BpmnStartConditionsVo startConditionsVo) {
        ExpressionParser expressionParser = (ExpressionParser)SpringBeanUtils.getBean(ExpressionParser.class);
        BusinessDataVo businessDataVo = startConditionsVo.getBusinessDataVo();
        StandardEvaluationContext evaluationContext = null;
        if (startConditionsVo.isLowCodeFlow()) {
            evaluationContext = new StandardEvaluationContext();
            Map lfConditions = startConditionsVo.getLfConditions();
            for (Map.Entry keyValuePair : lfConditions.entrySet()) {
                evaluationContext.setVariable((String)keyValuePair.getKey(), keyValuePair.getValue());
            }
        } else {
            evaluationContext = (EvaluationContext)SpringBeanUtils.getBean(EvaluationContext.class);
            evaluationContext.setVariable("it", (Object)businessDataVo);
        }
        Boolean evaluatedResult = (Boolean)expressionParser.parseExpression(expression).getValue((EvaluationContext)evaluationContext, Boolean.class);
        return Boolean.TRUE.equals(evaluatedResult);
    }
}

