/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.MessageSendTypeEnum;
import org.openoa.base.entity.UserMessage;
import org.openoa.base.interf.ProcessNoticeAdaptor;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BaseMsgInfo;
import org.openoa.base.vo.MailInfo;
import org.openoa.base.vo.MessageInfo;
import org.openoa.base.vo.UserMsgBatchVo;
import org.openoa.base.vo.UserMsgVo;
import org.openoa.engine.bpmnconf.service.biz.MessageServiceImpl;
import org.openoa.engine.factory.IAdaptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class UserMsgUtils {
    private static final Logger log = LoggerFactory.getLogger(UserMsgUtils.class);

    public static void sendMessages(UserMsgVo userMsgVo, MessageSendTypeEnum ... messageSendTypeEnums) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.doSendMessages(userMsgVo, messageService, messageSendTypeEnums);
        UserMsgUtils.insertUserMessage(userMsgVo, messageService);
    }

    public static void sendMessagesNoUserMessage(UserMsgVo userMsgVo, MessageSendTypeEnum ... messageSendTypeEnums) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.doSendMessages(userMsgVo, messageService, messageSendTypeEnums);
    }

    public static void insertUserMessage(UserMsgVo userMsgVo) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.insertUserMessage(userMsgVo, messageService);
    }

    private static void doSendMessages(UserMsgVo userMsgVo, MessageServiceImpl messageService, MessageSendTypeEnum[] messageSendTypeEnums) {
        if (!ObjectUtils.isEmpty((Object[])messageSendTypeEnums)) {
            if (!UserMsgUtils.checkEmployeeStatus(userMsgVo.getUserId()).booleanValue()) {
                return;
            }
            ArrayList messageSendTypeEnumList = Lists.newArrayList((Object[])messageSendTypeEnums);
            if (messageSendTypeEnumList.contains(MessageSendTypeEnum.MAIL)) {
                UserMsgUtils.sendMail(userMsgVo, messageService);
            }
            if (messageSendTypeEnumList.contains(MessageSendTypeEnum.MESSAGE)) {
                UserMsgUtils.sendSms(userMsgVo, messageService);
            }
            if (messageSendTypeEnumList.contains(MessageSendTypeEnum.PUSH)) {
                UserMsgUtils.sendAppPush(userMsgVo, messageService);
            }
        }
    }

    private static void sendAllMsg(UserMsgVo userMsgVo, MessageServiceImpl messageService) {
        UserMsgUtils.sendMail(userMsgVo, messageService);
        UserMsgUtils.sendSms(userMsgVo, messageService);
        UserMsgUtils.sendAppPush(userMsgVo, messageService);
    }

    private static MessageServiceImpl getMessageService() {
        return (MessageServiceImpl)SpringBeanUtils.getBean(MessageServiceImpl.class);
    }

    private static void insertUserMessage(UserMsgVo userMsgVo, MessageServiceImpl messageService) {
        if (!UserMsgUtils.checkEmployeeStatus(userMsgVo.getUserId()).booleanValue()) {
            return;
        }
        UserMessage userMessage = UserMsgUtils.buildUserMessage(userMsgVo);
        messageService.insertUserMessage(userMessage);
    }

    private static void sendAppPush(UserMsgVo userMsgVo, MessageServiceImpl messageService) {
        BaseMsgInfo baseMsgInfo = UserMsgUtils.buildBaseMsgInfo(userMsgVo);
        messageService.sendAppPush(baseMsgInfo, userMsgVo.getUserId());
    }

    private static void sendSms(UserMsgVo userMsgVo, MessageServiceImpl messageService) {
        MessageInfo messageInfo = UserMsgUtils.buildMessageInfo(userMsgVo);
        messageService.sendSms(messageInfo, userMsgVo.getUserId());
    }

    private static void sendMail(UserMsgVo userMsgVo, MessageServiceImpl messageService) {
        MailInfo mailInfo = UserMsgUtils.buildMailInfo(userMsgVo);
        messageService.sendMail(mailInfo, userMsgVo.getUserId());
    }

    public static void sendMessageBatch(List<UserMsgBatchVo> userMsgBatchVos) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.doSendMessageBatch(userMsgBatchVos, messageService);
        UserMsgUtils.insertUserMessageBatch(userMsgBatchVos, messageService);
    }

    public static void sendMessageBatchNoUserMessage(List<UserMsgBatchVo> userMsgBatchVos) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.doSendMessageBatch(userMsgBatchVos, messageService);
    }

    public static void insertUserMessageBatch(List<UserMsgBatchVo> userMsgBatchVos) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.insertUserMessageBatch(userMsgBatchVos, messageService);
    }

    public static void sendMessageBatchNoInsertUserMessageBatch(List<UserMsgBatchVo> userMsgBatchVos) {
        MessageServiceImpl messageService = UserMsgUtils.getMessageService();
        UserMsgUtils.doSendMessageBatch(userMsgBatchVos, messageService);
    }

    private static void doSendMessageBatch(List<UserMsgBatchVo> userMsgBatchVos, MessageServiceImpl messageService) {
        Map grouped = userMsgBatchVos.stream().flatMap(batch -> batch.messageSendTypeEnums.stream().map(type -> new AbstractMap.SimpleEntry<MessageSendTypeEnum, UserMsgVo>((MessageSendTypeEnum)type, batch.userMsgVo))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (Map.Entry messageSendTypeEnumListEntry : grouped.entrySet()) {
            MessageSendTypeEnum messageSendTypeEnum = messageSendTypeEnumListEntry.getKey();
            if (messageSendTypeEnum == null) continue;
            List userMsgVos = messageSendTypeEnumListEntry.getValue();
            IAdaptorFactory adaptorFactory = (IAdaptorFactory)SpringBeanUtils.getBean(IAdaptorFactory.class);
            ProcessNoticeAdaptor processNoticeAdaptor = adaptorFactory.getProcessNoticeAdaptor(messageSendTypeEnum);
            if (processNoticeAdaptor != null) {
                processNoticeAdaptor.sendMessageBatchByType(userMsgVos);
                continue;
            }
            log.warn("\u672a\u5b9e\u73b0\u7684\u6d88\u606f\u53d1\u9001\u7b56\u7565!{}", (Object)messageSendTypeEnum);
        }
    }

    private static void insertUserMessageBatch(List<UserMsgBatchVo> userMsgBatchVos, MessageServiceImpl messageService) {
        messageService.insertUserMessageBatch(userMsgBatchVos.stream().filter(o -> UserMsgUtils.checkEmployeeStatus(o.userMsgVo.getUserId())).map(o -> UserMsgUtils.buildUserMessage(o.getUserMsgVo())).collect(Collectors.toList()));
    }

    private static void sendAppPushBatch(MessageServiceImpl messageService, List<UserMsgVo> userMsgVos) {
        HashMap map = Maps.newHashMap();
        userMsgVos.forEach(o -> map.put(o.getUserId(), UserMsgUtils.buildBaseMsgInfo(o)));
        messageService.sendAppPushBatch(map);
    }

    private static void sendSmsBatch(MessageServiceImpl messageService, List<UserMsgVo> userMsgVos) {
        HashMap map = Maps.newHashMap();
        userMsgVos.forEach(o -> map.put(o.getUserId(), UserMsgUtils.buildMessageInfo(o)));
        messageService.sendSmsBatch(map);
    }

    private static void sendMailBatch(MessageServiceImpl messageService, List<UserMsgVo> userMsgVos) {
        HashMap map = Maps.newHashMap();
        userMsgVos.forEach(o -> map.put(o.getUserId(), UserMsgUtils.buildMailInfo(o)));
        messageService.sendMailBatch(map);
    }

    private static ArrayList<UserMsgVo> getUserMsgVos(Multimap<MessageSendTypeEnum, UserMsgVo> almMap, MessageSendTypeEnum messageSendTypeEnum) {
        ArrayList userMsgVos = Lists.newArrayList((Iterable)almMap.get((Object)messageSendTypeEnum));
        return userMsgVos;
    }

    private static Multimap<MessageSendTypeEnum, UserMsgVo> formatUserMsgBatchVos(List<UserMsgBatchVo> userMsgBatchVos) {
        userMsgBatchVos = userMsgBatchVos.stream().distinct().collect(Collectors.toList());
        ArrayListMultimap almMap = ArrayListMultimap.create();
        userMsgBatchVos.forEach(o -> {
            if (UserMsgUtils.checkEmployeeStatus(o.userMsgVo.getUserId()).booleanValue() && !ObjectUtils.isEmpty((Object)o.getMessageSendTypeEnums())) {
                o.getMessageSendTypeEnums().forEach(messageSendTypeEnum -> almMap.put(messageSendTypeEnum, (Object)o.getUserMsgVo()));
            }
        });
        return almMap;
    }

    private static UserMessage buildUserMessage(UserMsgVo userMsgVo) {
        UserMessage userMessage = UserMessage.builder().userId(Optional.ofNullable(userMsgVo.getUserId()).orElse("-999")).title(Optional.ofNullable(userMsgVo.getTitle()).orElse(userMsgVo.getContent())).content(userMsgVo.getContent()).isRead(Boolean.valueOf(false)).url(userMsgVo.getUrl()).appUrl(userMsgVo.getAppPushUrl()).node(userMsgVo.getTaskId()).source(Integer.valueOf(userMsgVo.getSource() == null ? 0 : userMsgVo.getSource())).build();
        if (userMessage.getSource() != 0) {
            userMessage.setTitle(userMsgVo.getTitle());
        }
        return userMessage;
    }

    public static BaseMsgInfo buildBaseMsgInfo(UserMsgVo userMsgVo) {
        return BaseMsgInfo.builder().msgTitle(userMsgVo.getTitle()).content(userMsgVo.getContent()).url(userMsgVo.getAppPushUrl()).build();
    }

    public static MessageInfo buildMessageInfo(UserMsgVo userMsgVo) {
        return MessageInfo.builder().receiver(userMsgVo.getMobile()).content(userMsgVo.getContent()).build();
    }

    public static MailInfo buildMailInfo(UserMsgVo userMsgVo) {
        return MailInfo.builder().receiver(userMsgVo.getEmail()).cc(userMsgVo.getCc()).title(userMsgVo.getTitle()).content(UserMsgUtils.joinEmailUrl(userMsgVo.getSsoSessionDomain(), userMsgVo.getContent(), userMsgVo.getEmailUrl())).build();
    }

    private static String joinEmailUrl(String systemDomain, String content, String emailUrl) {
        if (StringUtils.isNotEmpty((CharSequence)emailUrl)) {
            emailUrl = StringUtils.join((Object[])new String[]{"<a href='http://", systemDomain, "#", emailUrl, "'>\u70b9\u51fb\u67e5\u770b\u8be6\u60c5</a>"});
        }
        return StringUtils.join((Object[])new String[]{content, emailUrl});
    }

    private static Boolean checkEmployeeStatus(String userId) {
        if (ObjectUtils.isEmpty((Object)userId)) {
            return false;
        }
        AfUserService bean = (AfUserService)SpringBeanUtils.getBean(AfUserService.class);
        long count = bean.checkEmployeeEffective(userId);
        if (count == 0L) {
            return false;
        }
        return true;
    }
}

