/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.hystrix;

import com.netflix.hystrix.HystrixCommand;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;

public abstract class TracedHystrixCommand<R>
extends HystrixCommand<R> {
    static final String TAG_HYSTRIX_COMPONENT = "hystrix";
    static final String TAG_COMMAND_KEY = "commandKey";
    static final String TAG_COMMAND_GROUP = "commandGroup";
    static final String TAG_THREAD_POOL_KEY = "threadPoolKey";
    private final Tracer tracer;

    protected TracedHystrixCommand(Tracer tracer, HystrixCommand.Setter setter) {
        super(setter);
        this.tracer = tracer;
    }

    protected R run() throws Exception {
        String commandKeyName = this.getCommandKey().name();
        try (Scope scope = this.tracer.buildSpan(commandKeyName).withTag(Tags.COMPONENT.getKey(), TAG_HYSTRIX_COMPONENT).withTag(TAG_COMMAND_KEY, commandKeyName).withTag(TAG_COMMAND_GROUP, this.commandGroup.name()).withTag(TAG_THREAD_POOL_KEY, this.threadPoolKey.name()).startActive(true);){
            R r = this.doRun();
            return r;
        }
    }

    public abstract R doRun() throws Exception;
}

