/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.jdbc;

import io.opentracing.contrib.jdbc.TracingConnection;
import java.sql.Connection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class JdbcAspect {
    @Around(value="execution(java.sql.Connection *.getConnection(..)) && target(javax.sql.DataSource)")
    public Object getConnection(ProceedingJoinPoint pjp) throws Throwable {
        String dbType;
        Connection conn = (Connection)pjp.proceed();
        String url = conn.getMetaData().getURL();
        String user = conn.getMetaData().getUserName();
        boolean withActiveSpanOnly = false;
        try {
            dbType = url.split(":")[1];
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Invalid JDBC URL. Expected to find the database type after the first ':'. URL: " + url);
        }
        return new TracingConnection(conn, dbType, user, withActiveSpanOnly);
    }
}

